## PowerCons
#
#The PowerCons dataset contains the individual household electric power consumption in one year distributed in two season classes:  warm (class 1) and cold (class 2), depending on whether the power consumption is recorded during the warm seasons (from April to September) or the cold seasons (from October to March). Note that the electric power consumption profiles differ markedly within classes. The sampling rate is every ten-minute over a period of one year.
#
#Train size: 180
#
#Test size: 180
#
#Time series length: 144
#
#Number of classes: 2
#- Class 1: Warm season 
#- Class 2: Cold season
#
#Missing value: No
#
#Source: EDF R&D, Clamart, France 
@problemName PowerCons
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 144
@classLabel true 1 2
@data
3.66,3.23,2.87,2.5,1.85,1.74,1.63,1.47,1.19,0.91,0.53,0.34,0.14,0.16,0.17,0.17,0.18,0.2,0.2,0.2,0.2,0.21,0.22,0.24,0.2,0.17,0.19,0.2,0.16,0.12,0.13,0.16,0.19,0.18,0.17,0.2,0.19,0.18,0.17,0.16,0.18,0.19,0.16,0.12,0.35,0.57,0.85,1.14,1.14,1.2,1.2,1.2,2.05,2.9,1.6,0.3,1.3,2.29,1.38,0.46,0.88,1.31,1.29,1.28,2.56,3.84,3.01,2.18,2.68,3.17,3.11,3.06,2.77,2.22,1.67,1.69,1.45,1.21,1.17,1.12,1.17,1.21,1.16,1.12,0.77,0.42,0.28,0.15,0.17,0.2,0.18,0.17,0.17,0.16,0.16,0.16,0.14,0.12,0.15,0.18,0.17,0.16,0.12,0.13,0.14,0.17,0.19,0.19,0.1,0.1,0.15,0.19,0.16,0.13,0.17,0.2,0.19,0.17,0.19,0.18,0.18,0.16,0.15,0.17,0.18,0.15,0.12,0.15,0.18,0.16,0.15,0.12,0.13,0.13,0.13,0.19,0.19,0.1,0.1,0.14,0.17,0.16,0.14,0.2:1
0.44,0.33,0.23,0.18,0.19,0.23,0.26,0.25,0.24,0.22,0.21,0.2,0.19,0.15,0.7,1.26,1.2,0.79,0.38,0.25,0.18,0.19,0.22,0.2,0.18,0.2,0.21,0.2,0.21,0.19,0.19,0.22,0.22,0.17,0.18,0.22,0.21,0.18,0.19,0.21,0.21,0.69,1.17,0.8,0.43,0.66,0.88,1.11,1.33,1.22,1.12,0.88,0.64,0.39,0.15,0.18,0.19,0.19,0.2,0.17,0.17,0.2,0.2,0.16,0.17,0.2,0.2,0.18,0.18,0.19,0.19,0.2,0.18,0.17,0.19,0.2,0.17,0.16,0.2,0.21,0.18,0.17,0.19,0.19,0.19,0.19,0.17,0.18,0.2,0.19,0.16,0.19,0.2,0.18,0.17,0.18,0.19,0.19,0.19,0.17,0.18,0.21,0.21,0.16,0.16,0.53,0.88,1.16,1.28,0.89,0.5,0.35,0.21,0.17,0.19,0.2,0.19,0.16,0.2,0.21,0.19,0.18,0.19,0.19,0.19,0.2,0.18,0.18,0.21,0.21,0.17,0.17,0.21,0.2,0.18,0.18,0.48,0.67,0.61,0.32,0.24,0.18,0.2,0.18:1
0.88,0.64,0.39,0.39,0.39,0.36,0.32,0.3,0.83,1.35,1.3,0.77,0.25,0.31,0.37,0.31,0.27,0.26,0.24,0.29,0.28,0.26,0.27,0.3,0.36,0.31,0.26,0.2,0.24,0.28,0.3,0.32,0.29,0.27,0.26,0.28,0.29,0.24,0.19,0.26,0.33,0.32,0.31,0.29,0.26,0.58,0.89,0.61,0.33,0.41,0.97,1.52,1.47,1.42,1.31,1.04,0.77,0.6,0.43,1.35,2.27,1.39,0.51,0.51,1.74,1.65,0.4,0.4,0.46,0.53,0.55,0.56,0.48,0.42,0.41,0.4,0.4,0.4,0.67,0.94,0.88,0.77,0.67,0.67,1.37,1.37,1.1,0.83,0.61,0.39,0.38,0.37,0.36,0.39,0.43,0.43,0.6,0.6,0.67,0.73,0.63,0.54,0.6,0.56,0.53,0.55,0.57,0.29,0.0,0.0,0.84,1.68,1.62,1.55,1.41,1.37,1.34,1.29,1.25,1.28,1.3,1.33,1.36,1.39,1.41,1.43,1.43,1.36,1.3,1.32,1.34,1.43,1.41,1.4,1.28,1.05,0.81,1.05,1.29,1.29,1.0,0.71,0.64,0.57:1
0.27,0.2,0.2,0.23,0.23,0.21,0.19,0.22,0.21,0.21,0.19,0.19,0.22,0.22,0.19,0.18,0.22,0.22,0.2,0.19,0.2,0.21,0.21,0.18,0.18,0.21,0.21,0.18,0.17,0.19,0.19,0.19,0.17,0.18,0.21,0.2,0.17,0.17,0.2,0.19,0.18,0.17,0.19,0.21,0.96,2.23,2.02,1.41,1.3,1.33,1.36,1.3,1.27,1.24,1.01,0.78,0.46,0.15,0.17,0.17,0.18,0.2,0.19,0.16,0.17,0.19,0.19,0.18,0.16,0.18,0.2,0.19,0.17,0.16,0.18,0.19,0.19,0.17,0.17,0.2,0.2,0.18,0.17,0.17,0.18,0.19,0.17,0.15,0.18,0.19,0.19,0.17,0.16,0.12,0.15,0.18,0.16,0.17,0.18,0.18,0.18,0.15,0.16,0.19,0.19,0.11,0.65,1.2,1.2,1.0,0.81,0.51,0.21,0.29,0.39,0.42,0.34,0.31,0.36,0.54,0.73,0.8,0.88,0.78,1.16,1.54,1.79,2.04,1.99,1.6,1.22,1.06,0.98,0.97,0.99,0.87,0.75,0.44,0.14,0.2,0.21,0.21,0.19,0.23:1
3.3,3.98,2.75,1.52,1.82,2.11,1.19,0.28,0.28,0.34,0.34,0.28,0.23,0.24,0.25,0.26,0.25,0.23,0.2,0.17,0.17,0.33,0.33,0.43,0.53,0.87,1.21,1.0,0.79,0.58,0.36,0.29,0.23,0.21,0.19,0.19,0.19,0.12,1.28,2.45,1.41,0.37,0.4,0.55,0.7,1.05,1.39,1.29,1.25,1.2,1.2,1.19,1.19,1.16,1.14,1.14,1.16,1.25,1.25,1.25,0.28,0.28,0.24,0.19,0.19,0.19,0.19,0.15,0.15,0.16,0.15,0.14,0.17,0.19,0.22,0.25,0.25,0.25,0.23,0.21,0.17,0.14,0.18,0.21,0.19,0.19,0.19,0.23,0.27,0.19,0.26,0.33,0.36,0.38,0.33,0.27,0.27,0.22,0.18,0.23,0.29,0.26,0.2,0.25,0.3,0.28,0.26,0.18,0.25,0.31,0.5,0.68,1.06,1.45,1.4,0.84,0.28,0.27,0.27,0.54,0.81,1.13,1.45,1.4,1.41,1.43,1.43,2.79,2.79,2.06,2.2,2.34,3.65,2.51,1.36,1.36,1.29,1.29,1.27,1.27,1.25,1.23,1.12,1.01:1
0.95,1.0,1.03,1.0,0.96,0.93,0.9,0.64,0.38,0.39,0.4,0.36,0.31,0.32,0.32,0.31,0.31,0.31,0.3,0.27,0.24,0.27,0.31,0.31,0.32,0.34,0.38,0.41,0.37,0.54,0.71,1.05,1.39,0.83,0.27,0.31,0.29,0.27,0.26,0.25,0.27,0.3,0.27,0.34,0.41,1.36,2.32,1.37,0.43,0.57,0.72,0.71,0.69,0.72,0.75,1.2,1.66,2.76,3.86,2.84,1.82,2.37,2.92,2.2,1.48,2.02,2.56,2.61,2.87,3.13,3.13,1.15,1.15,0.76,0.36,0.37,0.38,0.34,0.32,0.34,0.36,0.3,0.3,0.31,0.31,0.3,0.29,0.28,0.28,0.28,0.31,0.33,0.45,0.58,0.56,0.54,0.53,0.53,0.5,0.5,0.53,0.46,0.4,0.37,0.33,0.35,0.36,0.4,0.43,0.47,0.96,1.45,1.48,1.12,0.77,0.55,0.32,0.38,0.36,0.34,0.34,0.35,0.36,0.37,0.35,0.34,1.78,3.21,4.3,4.08,3.87,3.59,3.32,3.31,3.3,3.33,3.37,3.31,3.36,3.41,3.36,3.32,3.38,3.44:1
2.06,1.86,1.34,0.82,0.54,0.26,0.27,0.26,0.25,0.25,0.27,0.29,0.25,0.23,0.22,0.19,0.18,0.17,0.19,0.19,0.18,0.17,0.19,0.2,0.23,0.25,0.27,0.26,0.25,0.23,0.22,0.19,0.18,0.17,0.19,0.18,0.14,0.57,0.99,1.45,1.86,2.63,3.4,2.49,1.59,1.5,1.42,1.39,1.36,1.28,1.24,1.26,1.24,1.19,0.87,0.53,0.26,0.24,0.25,0.26,0.23,0.18,0.17,0.2,0.19,0.16,0.17,0.2,0.19,0.17,0.2,0.25,0.27,0.24,0.25,0.24,0.21,0.17,0.18,0.19,0.19,0.17,0.18,0.19,0.19,0.18,0.22,0.25,0.27,0.25,0.25,0.23,0.21,0.17,0.18,0.18,0.19,0.17,0.18,0.19,0.19,0.18,0.22,0.25,0.27,0.25,0.44,0.84,1.24,0.89,0.53,0.37,0.2,0.21,0.26,0.26,0.26,0.34,0.43,0.53,0.63,0.44,0.25,0.23,0.19,0.12,0.12,3.48,3.48,2.79,2.09,2.48,2.87,2.62,2.33,1.83,1.32,1.0,0.72,0.53,0.36,0.25,0.15,0.23:1
0.79,0.6,0.4,0.26,0.12,0.13,0.14,0.23,0.32,0.26,0.19,0.19,0.28,0.28,0.28,0.25,0.23,0.24,0.26,0.29,0.29,0.23,0.15,0.12,0.22,0.22,0.19,0.15,0.15,0.16,0.16,0.19,0.22,0.17,0.11,0.16,0.21,0.25,0.29,0.27,0.24,1.09,1.94,1.7,1.46,1.39,1.39,1.39,1.37,1.34,1.32,1.24,1.16,1.19,1.22,1.23,1.23,1.19,1.14,1.03,0.92,0.56,0.21,0.2,0.18,0.21,0.23,0.29,0.27,0.24,0.24,0.23,0.23,0.27,0.31,0.25,0.18,0.19,0.22,0.25,0.21,0.18,0.15,0.15,0.17,0.2,0.2,0.19,0.18,0.18,0.18,0.22,0.2,0.19,0.17,0.27,0.37,0.36,0.35,0.28,0.21,0.21,0.32,0.43,0.31,0.27,0.23,0.79,1.35,1.32,0.99,0.67,0.41,0.15,0.2,0.2,0.25,0.14,0.14,0.93,1.73,1.67,1.15,0.63,0.62,0.61,1.28,1.95,2.93,3.92,3.74,3.39,3.04,3.66,4.29,2.67,1.05,1.62,2.18,1.52,0.86,0.86,2.09,2.09:1
0.29,0.3,0.3,0.31,0.3,0.27,0.25,0.26,0.26,0.28,0.27,0.27,0.28,0.3,0.31,0.31,0.3,0.84,1.37,1.11,0.85,0.59,0.32,0.29,0.28,0.29,0.29,0.32,0.34,0.36,0.33,0.31,0.29,0.26,0.26,0.26,0.26,0.26,0.29,0.66,1.04,0.84,0.64,0.73,1.11,1.49,1.62,1.75,1.52,1.29,1.32,1.34,1.33,1.32,1.33,0.8,0.27,0.3,0.32,0.33,0.32,0.29,0.26,0.25,0.27,0.3,0.29,0.25,0.25,0.27,0.31,0.32,0.31,0.31,0.32,0.32,0.28,0.25,0.26,0.3,0.31,0.27,0.24,0.26,0.31,0.35,0.34,0.32,0.31,0.33,0.3,0.26,0.25,0.28,0.32,0.3,0.26,0.24,0.29,0.35,0.65,0.96,1.17,1.38,1.38,0.8,0.22,0.27,0.33,0.4,0.48,0.56,0.59,1.34,2.1,2.73,2.0,1.28,1.22,1.15,0.97,0.79,2.22,3.65,4.38,5.11,4.46,3.75,3.01,3.01,1.61,1.61,1.72,1.84,1.53,1.22,0.94,0.65,0.45,0.34,0.23,0.24,0.32,0.41:1
0.11,0.18,0.25,0.54,0.83,1.03,1.22,1.32,0.76,0.19,0.23,0.27,0.18,0.18,0.18,0.18,0.18,0.16,0.15,0.16,0.16,0.18,0.21,0.23,0.25,0.23,0.22,0.21,0.2,0.19,0.18,0.18,0.18,0.16,0.16,0.18,0.2,0.21,0.23,0.25,0.29,0.53,0.77,0.61,0.45,0.64,0.83,1.04,1.25,1.22,0.86,0.49,0.42,0.36,0.3,0.25,0.29,0.33,0.32,0.31,0.35,0.4,0.36,0.32,0.29,0.26,0.27,0.48,0.69,1.02,1.34,1.12,0.9,0.6,0.29,0.26,0.31,0.36,0.38,0.4,0.31,0.41,0.5,0.46,0.41,0.39,0.39,0.39,0.4,0.31,0.38,0.44,0.39,0.34,0.37,0.4,0.43,0.47,0.45,0.43,0.42,0.4,0.39,0.37,0.38,0.39,0.38,0.38,0.42,0.41,0.4,0.53,0.67,0.67,2.78,2.78,2.22,1.66,0.92,0.17,0.21,0.5,0.79,1.22,1.22,3.19,3.19,3.03,2.87,2.87,2.96,2.96,2.96,2.71,2.71,2.71,2.15,2.15,1.59,1.03,1.27,1.5,1.44,1.37:1
0.23,0.25,0.25,0.23,0.21,0.19,0.18,0.2,0.21,0.23,0.24,0.24,0.23,0.2,0.19,0.18,0.19,0.21,0.23,0.24,0.23,0.22,0.21,0.19,0.18,0.19,0.22,0.23,0.24,0.23,0.22,0.21,0.2,0.19,0.19,0.21,0.23,0.24,0.22,0.21,0.22,0.53,0.69,0.55,0.26,0.65,1.05,1.2,1.35,1.29,1.24,1.21,1.21,1.26,0.96,0.66,0.42,0.18,0.21,0.21,0.17,0.16,0.19,0.24,0.25,0.23,0.23,0.25,0.25,0.23,0.23,0.23,0.26,0.3,0.34,0.89,1.44,0.88,0.32,0.22,0.23,0.26,0.3,0.29,0.23,0.33,0.42,0.37,0.31,0.28,0.31,0.36,0.42,0.37,0.37,0.37,0.34,0.31,0.27,0.35,0.43,0.45,0.45,1.43,1.43,1.52,1.61,1.38,1.34,1.3,1.38,0.98,0.58,0.37,0.17,0.24,0.32,0.24,0.23,0.28,1.58,2.88,1.95,1.02,0.96,0.88,1.61,2.33,3.47,4.6,2.94,2.12,1.3,1.2,1.1,1.29,1.48,3.2,2.3,1.4,1.33,1.28,0.91,0.54:1
0.4,0.36,0.33,0.35,0.58,0.81,1.35,1.15,0.95,0.61,0.27,0.29,0.31,0.33,0.34,0.34,0.35,0.32,0.28,0.28,0.29,0.29,0.31,0.31,0.24,0.24,0.27,0.31,0.31,0.38,0.38,0.33,0.27,0.28,0.29,0.29,0.29,0.3,0.31,0.75,1.2,1.75,2.31,1.45,0.6,1.15,1.71,2.01,2.31,2.43,2.54,1.92,1.31,0.88,0.44,0.37,0.29,0.89,1.49,0.92,0.35,0.31,0.59,0.86,0.88,0.87,0.86,0.82,0.78,0.71,0.65,0.54,0.51,0.47,0.56,0.65,0.56,0.48,0.48,0.78,0.78,0.93,1.09,1.08,0.93,0.77,0.93,1.08,1.31,1.54,1.6,1.72,1.83,1.77,1.71,1.28,0.84,0.84,0.83,0.6,0.6,0.46,0.33,0.45,0.57,0.6,0.63,0.61,0.59,0.59,0.59,0.59,0.7,0.82,0.81,0.8,0.59,0.37,0.43,0.98,1.52,1.98,1.77,1.56,2.12,2.67,2.8,2.94,2.89,2.84,2.41,1.98,1.63,1.33,1.02,0.66,0.31,0.3,0.3,0.27,0.24,0.28,0.33,0.28:1
0.23,0.28,0.3,0.28,0.27,0.28,0.29,0.28,0.3,0.34,0.35,0.31,0.31,0.31,0.28,0.25,0.26,0.26,0.26,0.24,0.26,0.29,0.33,0.32,0.33,0.33,0.3,0.27,0.27,0.28,0.28,0.27,0.29,0.27,0.26,0.29,0.36,0.37,0.31,0.23,1.65,3.08,2.42,1.77,1.85,1.93,1.85,1.77,1.58,2.09,2.6,2.08,1.57,1.54,1.96,2.38,2.09,1.81,1.84,1.86,1.86,1.85,1.84,1.87,1.89,1.88,1.86,1.89,1.73,1.56,1.56,1.43,1.43,1.34,1.34,1.41,1.43,1.45,1.46,1.46,1.44,1.41,1.39,1.39,1.38,1.38,1.21,0.8,0.34,0.29,0.31,0.38,0.41,0.39,0.35,0.37,0.38,0.34,0.35,0.4,0.4,0.33,0.29,0.31,0.33,0.32,0.34,0.36,0.36,0.34,0.34,0.33,0.33,0.33,0.36,0.86,1.35,0.95,0.55,0.48,0.41,0.38,0.41,0.38,0.34,0.32,0.36,0.34,0.32,0.31,0.5,0.69,1.08,1.48,1.2,0.93,0.63,0.34,0.41,1.22,2.04,1.62,0.98,0.33:1
0.22,0.22,0.25,0.29,0.24,0.24,0.29,0.31,0.33,0.27,0.26,0.29,0.3,0.26,0.23,0.26,0.29,0.29,0.25,0.24,0.27,0.32,0.33,0.31,0.29,0.29,0.29,0.26,0.25,0.26,0.79,1.32,1.32,1.33,1.36,1.01,0.67,0.49,0.3,0.29,0.27,0.25,0.26,0.28,0.27,0.25,0.24,0.26,0.29,0.27,0.24,0.25,0.32,0.36,0.32,0.26,0.25,0.29,0.29,0.25,0.22,0.22,0.25,0.28,0.23,0.22,0.24,0.28,0.32,0.28,0.27,0.29,0.26,0.23,0.22,0.25,0.29,0.29,0.24,0.23,0.27,0.3,0.3,0.3,0.31,0.32,0.3,0.26,0.24,0.26,0.28,0.28,0.25,0.26,0.29,0.47,0.65,1.01,1.37,1.38,1.36,0.99,0.62,0.46,0.31,0.26,0.24,0.26,0.28,0.27,0.24,0.24,0.28,0.31,0.32,0.29,0.28,0.28,0.27,0.24,0.23,0.27,0.29,0.27,0.23,0.24,0.29,0.31,0.29,0.29,0.31,0.31,0.29,0.24,0.22,0.24,0.25,0.27,0.24,0.24,0.29,0.26,0.24,0.25:1
0.4,0.31,0.3,0.33,0.34,0.28,0.27,0.3,0.29,0.27,0.26,0.28,0.31,0.32,0.3,0.32,0.37,0.36,0.3,0.27,0.28,0.29,0.28,0.26,0.28,0.28,0.27,0.26,0.28,0.28,0.27,0.26,0.31,0.36,0.35,0.29,0.27,0.31,0.35,1.44,2.52,2.41,2.3,2.28,2.27,2.35,2.24,2.14,2.08,1.77,1.46,1.42,1.36,1.32,1.32,1.34,1.33,1.33,1.34,1.33,1.33,1.33,1.36,1.36,1.33,1.37,1.42,1.44,1.39,1.33,1.3,1.34,1.38,1.32,1.3,0.87,0.44,0.28,0.37,0.46,1.05,1.65,1.69,1.59,1.5,1.45,1.39,1.38,1.39,1.41,1.4,1.39,0.86,0.33,0.29,0.29,0.32,0.32,0.31,0.34,0.4,0.38,0.3,0.25,0.25,0.27,0.29,0.33,0.37,0.4,0.37,0.32,0.29,0.81,1.33,1.35,1.41,1.48,1.71,1.94,1.92,1.92,3.02,3.02,2.43,1.84,1.72,1.6,1.46,1.46,3.87,3.87,4.08,4.29,4.23,3.71,3.2,3.2,0.83,0.83,0.6,0.49,0.38,0.47:1
0.37,0.37,0.34,0.32,0.31,0.32,0.28,0.24,0.25,0.29,0.3,0.26,0.24,0.27,0.29,0.28,0.25,0.3,0.37,0.39,0.33,0.29,0.32,0.3,0.27,0.23,0.26,0.31,0.31,0.25,0.24,0.29,0.3,0.27,0.27,0.32,0.37,0.37,0.33,0.32,0.31,0.29,0.27,0.27,0.28,0.28,0.27,0.27,0.29,0.28,0.26,0.26,0.31,0.34,0.34,0.29,0.88,1.47,1.39,1.33,1.31,0.82,0.32,0.26,0.24,0.28,0.3,0.28,0.23,0.27,0.34,0.36,0.33,0.3,0.33,0.3,0.27,0.23,0.26,0.31,0.31,0.25,0.24,0.28,0.3,0.27,0.24,0.27,0.33,0.35,0.33,0.33,0.34,0.34,0.29,0.27,0.28,0.28,0.27,0.27,0.29,0.28,0.27,0.26,0.29,0.32,0.32,0.33,0.35,0.38,0.35,0.28,0.27,0.3,0.3,0.25,0.24,0.28,0.28,0.27,0.23,0.26,0.31,0.34,0.31,0.31,0.34,0.8,1.26,1.3,1.34,1.41,1.1,0.79,0.55,0.3,0.31,0.28,0.25,0.26,0.29,0.31,0.31,0.31:1
0.28,0.24,0.19,0.19,0.18,0.2,0.21,0.63,1.05,1.26,1.02,0.78,0.5,0.22,0.16,0.17,0.17,0.21,0.25,0.23,0.2,0.21,0.24,0.27,0.19,0.11,0.14,0.18,0.23,0.21,0.2,0.2,0.19,0.19,0.18,0.16,0.16,0.19,0.22,0.33,0.33,0.61,0.61,0.61,1.34,1.34,1.35,1.36,1.36,1.37,1.36,1.35,1.25,1.28,1.31,1.32,0.85,0.37,0.35,0.32,0.26,0.21,0.18,0.14,0.14,0.36,0.36,0.39,0.42,0.37,0.32,0.28,0.24,0.69,1.14,0.78,0.42,0.56,0.54,0.52,0.48,0.43,0.27,0.79,1.3,1.3,1.41,1.53,0.92,0.32,0.32,0.27,0.27,1.29,2.31,1.24,0.17,0.17,0.34,0.34,0.25,0.17,0.18,0.2,0.2,0.16,0.17,0.21,0.21,0.33,0.45,0.59,0.73,0.77,0.81,0.85,0.89,0.94,0.99,1.54,2.09,1.81,1.53,1.21,0.89,0.74,1.06,1.38,1.29,1.21,1.14,1.07,1.04,1.01,1.17,1.32,1.4,1.47,1.47,0.17,0.17,0.19,0.21,0.2:1
0.77,0.49,0.2,0.17,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.15,0.19,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.16,0.16,0.18,0.18,0.14,0.15,0.18,0.19,0.14,0.15,0.18,0.18,0.15,0.16,0.18,0.17,0.16,0.16,0.17,0.16,0.17,0.17,0.14,0.15,0.18,0.17,0.13,0.12,0.14,0.17,0.14,0.16,0.19,0.16,0.1,0.46,0.83,0.98,1.13,1.19,0.76,0.34,0.24,0.17,0.13,0.11,0.97,1.82,1.82,2.13,2.13,1.62,1.12,1.96,2.8,2.12,1.45,1.01,0.5,0.18,0.31,0.45,0.32,0.2,0.21,0.24,0.31,0.38,0.33,0.28,0.22,0.21,0.46,0.83,1.15,1.18,1.09,1.0,0.59,0.18,0.21,0.21,0.15,0.32,0.5,0.49,0.47,0.36,0.28,0.23,0.16,0.71,1.27,1.3,1.38,1.87,2.37,2.01,1.66,1.57,1.47,1.28,1.42,1.57,1.57,1.28,1.28,1.19,1.06,0.93,0.71,0.48,0.45,0.38,0.24,0.18,0.2,0.2,0.16:1
1.34,1.32,1.31,1.32,1.3,1.28,1.29,1.32,0.71,0.11,0.17,0.2,0.18,0.16,0.17,0.2,0.19,0.2,0.24,0.27,0.25,0.2,0.19,0.2,0.18,0.16,0.16,0.19,0.18,0.15,0.16,0.22,0.23,0.22,0.23,0.29,0.53,0.76,1.5,1.83,2.17,2.17,2.15,2.12,2.1,1.83,1.57,0.97,0.36,0.26,0.21,0.22,0.2,0.17,0.15,0.15,0.17,0.19,0.15,0.15,0.18,0.22,0.21,0.24,0.28,0.27,0.19,0.18,0.21,0.2,0.15,0.15,0.21,0.21,0.17,0.16,0.22,0.23,0.25,0.24,0.26,0.26,0.2,0.17,0.18,0.2,0.19,0.17,0.18,0.2,0.19,0.2,0.24,0.3,0.48,0.66,0.96,1.27,0.73,0.19,0.19,0.19,0.19,0.17,0.19,0.21,0.24,0.29,0.34,0.35,0.32,0.28,0.28,0.34,0.45,0.65,0.85,0.78,0.69,0.61,0.61,3.36,3.36,3.26,3.15,4.12,5.09,4.16,3.23,3.3,3.21,3.08,2.47,1.87,1.62,1.37,1.25,1.12,0.77,0.43,0.41,0.38,0.35,0.32:1
0.16,0.19,0.18,0.16,0.17,0.19,0.18,0.15,0.18,0.19,0.15,0.53,0.91,1.17,0.85,0.53,0.32,0.11,0.19,0.19,0.15,0.16,0.19,0.18,0.17,0.17,0.18,0.18,0.19,0.17,0.16,0.19,0.18,0.15,0.15,0.18,0.19,0.17,0.17,0.17,0.18,0.24,0.47,0.7,1.08,1.46,2.03,2.6,2.22,1.8,1.47,1.15,1.17,1.17,1.18,1.2,1.18,1.16,1.2,1.19,1.17,1.16,1.19,1.19,1.19,1.19,1.17,1.14,0.87,0.6,0.38,0.16,0.19,0.18,0.16,0.18,0.19,0.19,0.19,0.18,0.18,0.2,0.21,0.16,0.16,0.21,0.21,0.18,0.18,0.19,0.19,0.2,0.19,0.17,0.18,0.18,0.18,0.16,0.19,0.21,0.19,0.18,0.18,0.19,0.19,0.22,0.27,0.35,0.44,0.48,0.34,0.21,0.34,0.72,1.09,1.26,1.43,1.44,1.37,1.3,0.95,0.62,0.29,0.26,0.26,0.26,0.96,0.96,0.96,0.45,0.45,0.39,0.32,0.28,0.25,0.25,1.4,2.55,1.93,1.32,1.25,1.23,1.19,1.09:1
0.16,0.16,0.17,0.16,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.14,0.17,0.18,0.16,0.17,0.16,0.16,0.16,0.19,0.17,0.13,0.11,0.14,0.18,0.13,0.15,0.19,0.18,0.15,0.15,0.17,0.16,0.16,0.18,0.16,0.14,0.17,0.19,0.16,0.13,0.14,0.67,1.21,1.19,1.21,0.94,0.67,0.43,0.2,0.16,0.16,0.17,0.18,0.15,0.14,0.18,0.18,0.15,0.13,0.17,0.19,0.16,0.14,0.16,0.17,0.16,0.17,0.17,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.14,0.17,0.19,0.17,0.17,0.16,0.15,0.16,0.19,0.18,0.13,0.15,0.19,0.19,0.14,0.13,0.18,0.19,0.16,0.15,0.17,0.17,0.17,0.18,0.17,0.15,0.16,0.19,0.18,0.13,0.14,0.2,0.2,0.1,0.69,1.27,1.26,1.21,0.94,0.66,0.42,0.18,0.19,0.17,0.14,0.14,0.16,0.18,0.13,0.15,0.19,0.19,0.15,0.15,0.18,0.17,0.16,0.17,0.16,0.15,0.15:1
0.11,0.18,0.2,0.17,0.16,0.17,0.19,0.17,0.17,0.17,0.17,0.17,0.19,0.18,0.16,0.17,0.19,0.18,0.15,0.17,0.19,0.18,0.15,0.17,0.18,0.17,0.14,0.17,0.16,0.15,0.14,0.18,0.17,0.15,0.15,0.18,0.19,0.17,0.16,0.17,0.17,0.17,0.18,0.38,0.59,0.91,1.24,0.67,0.1,0.18,0.19,0.15,0.15,0.19,0.19,0.15,0.14,0.2,0.2,0.16,0.14,0.18,0.18,0.16,0.16,0.17,0.16,0.16,0.17,0.16,0.16,0.18,0.18,0.14,0.16,0.19,0.19,0.13,0.14,0.19,0.19,0.15,0.15,0.19,0.18,0.16,0.16,0.18,0.17,0.16,0.17,0.17,0.16,0.18,0.18,0.15,0.16,0.19,0.19,0.13,0.14,0.18,0.2,0.15,0.15,0.19,0.18,0.16,0.16,0.19,0.4,0.61,0.89,1.16,1.14,0.89,0.49,0.14,0.15,0.19,0.19,0.13,0.14,0.19,0.19,0.15,0.15,0.19,0.18,0.16,0.16,0.17,0.16,0.17,0.17,0.16,0.16,0.19,0.18,0.14,0.15,0.19,0.2,0.11:1
1.22,0.84,0.47,0.98,1.49,1.49,1.5,1.53,1.53,0.29,0.29,0.29,0.3,0.31,0.31,0.29,0.3,0.31,0.31,0.29,0.31,0.36,0.37,0.35,0.31,0.32,0.35,0.33,0.31,0.31,0.34,0.64,0.94,1.19,1.44,0.94,0.52,0.38,0.33,0.28,0.29,0.31,0.32,0.29,0.28,0.29,0.31,0.29,0.28,0.28,0.33,0.35,0.35,0.34,0.34,0.38,0.46,0.63,0.81,0.83,0.83,0.83,0.82,0.82,0.81,0.82,0.84,0.46,0.46,1.44,1.44,1.44,1.42,1.4,1.39,1.39,1.41,1.4,1.4,1.4,1.44,1.44,1.44,1.43,1.44,1.42,1.4,1.4,0.88,0.35,0.3,0.29,0.34,0.33,0.3,0.33,0.45,0.37,0.29,0.31,0.36,0.3,0.25,0.27,0.32,0.28,0.24,0.27,0.31,0.31,0.3,0.34,0.37,0.32,0.27,0.26,0.28,0.28,0.28,0.26,0.26,0.28,0.3,0.26,0.25,0.82,1.4,1.52,1.19,0.86,0.79,0.74,0.74,0.78,0.81,0.79,0.76,1.34,1.93,2.32,2.32,0.92,0.92,0.82:1
1.47,1.38,1.3,1.04,0.77,0.51,0.25,0.27,0.29,0.27,0.23,0.21,0.24,0.24,0.23,0.3,0.31,0.33,0.28,0.23,0.22,0.25,0.26,0.27,0.25,0.21,0.24,0.28,0.23,0.23,0.27,0.3,0.28,0.25,0.25,0.27,0.26,0.23,0.23,0.28,0.3,0.29,0.27,0.25,0.28,0.26,0.24,0.24,0.24,0.25,0.25,0.23,0.24,0.26,0.26,0.24,0.24,0.25,0.24,0.22,0.23,0.24,0.25,0.26,0.22,0.78,1.33,1.3,1.27,1.3,1.06,0.82,0.54,0.25,0.27,0.29,0.3,0.27,0.23,0.23,0.26,0.27,0.26,0.26,0.28,0.3,0.28,0.24,0.23,0.28,0.33,0.31,0.29,0.28,0.29,0.27,0.23,0.22,0.27,0.25,0.23,0.22,0.21,0.23,0.25,0.22,0.2,0.29,0.38,0.3,0.25,0.23,0.24,0.25,0.22,0.23,0.27,0.29,0.28,0.25,0.25,0.26,0.25,0.23,0.24,0.25,0.26,0.27,0.25,0.26,0.27,0.27,0.25,0.77,1.3,1.32,1.35,1.16,0.97,0.63,0.29,0.24,0.23,0.25:1
2.08,1.85,1.61,1.47,1.0,0.54,0.44,0.34,0.34,0.35,0.31,0.24,0.24,0.25,0.24,0.23,0.21,0.19,0.17,0.14,0.16,0.19,0.17,0.23,0.28,0.28,0.26,0.26,0.21,0.16,0.16,0.23,0.24,0.24,0.24,0.25,0.22,0.23,0.24,0.23,0.22,0.25,1.44,2.63,2.01,1.38,1.36,1.33,1.32,1.31,1.3,1.29,1.29,1.29,0.88,0.47,0.32,0.17,0.15,0.13,0.13,0.22,0.29,0.2,0.2,0.22,0.24,0.24,0.2,0.22,0.22,0.21,0.2,0.25,0.24,0.23,0.23,0.22,0.18,0.23,0.28,0.28,0.27,0.27,0.27,0.24,0.2,0.2,0.16,0.16,0.15,0.13,0.57,1.01,1.21,1.07,0.93,0.55,0.16,0.17,0.19,0.22,0.22,0.23,0.25,0.28,0.26,0.24,0.24,0.2,0.2,0.25,0.29,1.14,1.99,1.27,0.54,0.43,0.46,0.48,0.44,0.4,0.48,0.58,0.67,0.57,0.47,0.48,0.58,0.67,2.2,3.72,3.98,4.23,3.6,2.97,2.22,2.22,0.36,0.36,0.4,0.36,0.33,0.35:1
0.58,0.55,0.53,0.5,0.42,0.34,0.31,0.31,0.3,0.39,0.37,0.35,0.31,0.27,0.36,0.32,0.28,0.25,0.31,0.36,0.32,0.27,0.19,0.24,0.29,0.25,0.21,0.18,0.23,0.28,0.25,0.21,0.18,0.23,0.27,0.29,0.31,0.26,0.29,0.32,0.32,0.31,1.29,2.26,2.12,1.98,1.81,1.64,1.51,1.38,1.33,1.27,1.28,1.29,1.3,1.28,1.24,1.26,1.28,0.81,0.35,0.31,0.31,0.3,0.32,0.34,0.32,0.3,0.28,0.27,0.25,0.26,0.24,0.2,0.22,0.23,0.27,0.23,0.19,0.2,0.21,0.28,0.28,0.27,0.25,0.3,0.36,0.3,0.25,0.24,0.28,0.33,0.28,0.24,0.17,0.21,0.24,0.23,0.22,0.19,0.19,0.23,0.24,0.25,0.21,0.17,0.23,0.29,0.35,0.25,0.25,1.44,1.44,1.39,1.0,0.61,0.63,0.65,0.55,0.45,0.5,0.55,0.65,0.76,0.66,1.9,3.15,2.16,1.18,0.82,1.06,1.3,3.35,5.39,4.76,4.12,3.61,3.1,2.9,2.7,1.55,0.39,0.42,0.45:1
1.72,1.47,1.37,1.26,1.14,0.98,0.62,0.27,0.18,0.16,0.19,0.2,0.18,0.19,0.19,0.18,0.19,0.2,0.18,0.17,0.2,0.18,0.16,0.16,0.2,0.21,0.18,0.17,0.18,0.19,0.19,0.2,0.19,0.16,0.14,0.16,0.19,0.16,0.18,0.21,0.2,0.18,0.18,0.19,0.18,0.19,0.19,0.19,0.2,0.61,1.04,1.32,1.32,1.36,1.49,1.8,2.12,1.76,1.39,1.4,1.39,1.37,1.35,2.18,3.01,3.03,3.05,1.33,1.99,2.64,2.52,2.41,1.84,1.27,1.23,1.2,1.18,1.18,1.21,1.21,1.17,1.17,1.21,1.21,1.17,1.16,1.2,1.2,1.18,1.18,1.19,1.18,1.18,1.19,1.18,1.17,1.2,1.2,1.17,1.16,1.2,1.18,1.15,1.13,0.97,0.81,0.47,0.13,0.16,0.17,0.17,0.18,0.16,0.14,0.15,0.17,0.17,0.13,0.14,0.15,0.16,0.14,0.16,0.19,0.17,0.16,0.16,0.16,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.12,0.99,1.87,1.78,1.69:1
0.19,0.24,0.26,0.28,0.26,0.25,0.25,0.25,0.25,0.25,0.22,0.2,0.19,0.18,0.21,0.24,0.19,0.13,0.16,0.19,0.17,0.14,0.14,0.11,0.11,0.16,0.2,0.19,0.17,0.17,0.2,0.23,0.15,0.13,0.12,0.15,0.74,1.32,1.27,0.73,0.19,0.26,0.33,0.33,1.98,1.98,1.42,1.5,1.59,1.53,1.47,1.35,1.24,1.23,1.22,1.22,1.22,1.26,1.3,1.25,1.19,0.68,0.17,0.18,0.19,0.18,0.18,0.15,0.15,0.15,0.29,0.25,0.21,0.12,0.14,0.17,0.17,0.18,0.14,0.1,0.13,0.16,0.19,0.19,0.19,0.23,0.23,0.19,0.19,0.18,0.18,0.17,0.17,0.18,0.19,0.17,0.18,0.19,0.27,0.25,0.23,0.17,0.1,0.18,0.26,0.26,0.18,0.1,0.16,0.21,0.24,0.26,0.21,0.16,0.33,0.5,0.87,1.24,1.2,1.66,2.11,1.82,1.52,1.04,0.55,0.42,0.28,0.28,0.43,0.57,0.72,0.86,0.83,0.8,0.74,0.67,0.51,0.35,0.4,0.43,0.45,0.33,0.29,0.25:1
0.27,0.24,0.26,0.2,0.2,0.25,0.29,0.31,0.33,0.33,0.29,0.32,0.29,0.29,0.27,0.25,0.27,0.29,0.3,0.26,0.22,0.21,0.21,0.21,0.26,0.23,0.33,0.33,0.34,0.35,0.32,0.32,0.32,0.36,0.28,0.2,0.21,0.21,0.21,0.24,0.24,0.43,0.61,0.97,1.32,0.97,0.64,0.32,0.28,0.24,0.49,0.75,0.58,0.4,0.39,0.34,0.29,0.29,0.28,0.28,0.3,0.32,0.32,0.38,0.38,0.37,0.36,0.36,0.36,0.38,0.34,0.31,0.37,0.42,0.43,0.43,0.71,0.99,1.14,1.29,1.16,1.03,0.69,0.34,0.55,0.76,1.1,1.45,2.12,2.12,1.04,1.04,1.73,2.41,1.4,0.4,0.38,0.37,0.46,0.54,0.51,0.25,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03,0.05,0.03,0.0,0.05,0.1,0.33,0.55,0.48,0.55,0.62,0.65,0.68,0.68,0.75,0.75,1.34,1.92,1.77,1.61,1.5,1.5,2.13,2.13,2.01,1.9,1.75,1.6,1.49,1.38,1.37,1.36,1.35,1.34,1.34:1
0.34,0.31,0.3,0.29,0.29,0.3,0.31,0.8,1.28,1.34,1.4,0.83,0.27,0.27,0.33,0.32,0.22,0.31,0.31,0.3,0.29,0.28,0.26,0.27,0.28,0.22,0.3,0.37,0.3,0.22,0.25,0.28,0.26,0.24,0.25,0.26,0.29,0.31,0.28,0.24,1.02,1.8,1.47,1.74,2.01,2.39,2.76,2.76,1.53,1.53,1.39,1.36,1.32,1.34,1.31,1.28,1.27,1.27,1.31,1.34,1.33,1.32,0.82,0.32,0.32,0.27,0.27,0.27,0.38,0.38,1.12,1.86,1.46,1.06,1.24,1.43,3.2,4.97,6.5,4.75,3.0,3.0,3.0,3.72,4.45,2.65,2.95,3.26,3.22,3.19,3.0,2.61,2.22,1.84,1.46,1.45,1.44,1.46,1.47,1.45,1.43,1.19,0.94,0.71,0.49,0.43,0.37,0.43,0.39,0.35,0.41,0.47,0.58,0.69,0.69,1.28,1.28,1.21,1.51,1.81,1.92,2.09,2.26,2.39,2.57,2.76,2.76,1.37,1.37,2.08,2.3,2.53,2.58,3.22,3.86,3.49,3.13,2.67,2.13,1.6,0.96,0.32,0.34,0.37:1
2.3,2.28,2.27,2.26,2.25,2.14,2.03,2.0,2.02,2.05,2.05,1.93,1.93,1.93,1.93,1.93,2.01,2.01,2.04,2.02,2.0,1.94,1.94,1.93,1.93,1.86,1.91,1.91,2.36,2.8,2.88,2.95,2.56,2.16,2.66,3.16,3.03,2.9,2.77,2.64,2.22,1.8,1.84,1.88,1.99,2.1,2.27,2.45,2.45,2.66,2.55,2.55,2.42,2.3,2.09,2.44,2.8,2.92,3.05,2.98,2.92,2.79,2.67,1.87,1.09,0.3,1.71,3.12,4.35,3.79,3.23,3.23,3.34,3.44,3.48,3.52,3.61,3.22,2.82,2.3,1.78,2.62,3.47,3.58,3.7,3.5,3.76,4.02,3.65,3.27,3.44,3.61,2.34,2.3,2.27,1.91,1.14,0.38,0.4,0.47,0.54,0.48,0.38,0.29,1.2,2.11,2.53,2.94,2.75,2.56,2.73,2.91,3.38,3.57,3.75,3.55,3.36,3.23,3.47,3.71,3.16,2.61,2.63,3.08,3.53,3.2,2.86,2.75,2.64,2.47,2.36,2.24,2.19,2.14,1.83,1.52,1.48,1.44,1.42,1.4,1.4,1.41,1.41,1.41:2
0.59,0.47,0.35,0.3,0.24,0.24,0.31,0.28,0.24,0.24,0.27,0.29,0.31,0.22,0.3,0.37,0.34,0.31,0.31,0.34,0.35,0.32,0.26,0.24,0.31,0.27,0.24,0.23,0.26,0.3,0.3,0.25,0.25,0.29,0.31,0.33,0.31,0.33,0.36,0.38,1.36,2.34,3.13,3.93,3.21,2.49,2.63,2.16,1.7,1.49,1.29,1.34,1.39,1.44,1.44,1.43,1.42,1.39,1.36,1.35,1.36,1.38,1.35,1.35,1.35,1.34,1.32,1.33,1.35,1.38,1.07,0.75,0.58,0.41,0.36,0.34,0.34,0.33,0.3,0.3,0.3,0.3,0.29,0.27,0.27,0.3,0.3,0.28,0.27,0.29,0.33,0.33,0.33,0.35,0.38,0.37,0.31,0.28,0.28,0.29,0.29,0.25,0.24,0.28,0.33,0.27,0.28,0.36,0.34,0.32,1.52,2.73,2.8,2.88,3.22,4.99,6.76,5.26,3.76,3.44,3.11,2.6,2.08,1.61,1.14,1.24,1.45,1.67,1.5,2.55,3.61,4.0,4.45,4.82,3.6,2.39,2.13,1.89,1.89,1.37,1.37,0.83,0.29,0.36:2
1.51,1.59,1.56,1.53,1.89,2.26,1.41,0.88,0.34,0.33,0.32,0.32,0.31,0.34,0.36,0.31,0.26,0.3,0.35,0.34,0.32,0.35,0.38,0.34,0.3,0.31,0.32,0.32,0.29,0.29,0.29,0.26,0.26,0.25,0.27,0.28,0.27,0.3,0.33,0.34,0.36,0.36,0.37,0.37,1.31,2.26,2.35,2.43,2.34,2.24,2.19,2.15,2.12,2.09,1.98,1.73,1.47,1.45,1.42,1.57,1.72,1.61,1.5,1.95,2.39,2.84,3.29,3.0,3.0,1.33,1.33,1.32,1.3,1.35,1.41,1.41,1.47,1.47,1.44,1.44,1.64,1.64,1.82,1.99,1.74,1.49,2.08,2.67,2.5,2.34,1.99,1.63,1.71,1.71,4.47,4.47,3.9,3.34,2.94,2.54,2.05,1.57,1.49,1.4,1.4,2.09,2.78,2.65,2.48,2.31,2.23,2.14,2.05,1.85,1.66,2.18,2.71,2.85,2.84,2.83,2.59,2.35,1.69,1.57,1.45,1.65,1.86,1.86,1.36,1.36,2.0,2.65,2.41,2.18,1.82,1.45,0.94,0.63,0.31,0.42,0.43,0.44,0.35,0.27:2
0.44,0.41,0.39,0.37,0.41,0.36,0.32,0.32,0.38,0.38,0.34,0.29,0.3,0.3,0.27,0.25,0.2,0.28,0.36,0.3,0.25,0.27,0.3,0.28,0.27,0.21,0.61,1.01,1.15,1.28,1.28,0.31,0.31,0.28,0.32,0.36,0.36,0.31,0.26,0.26,0.26,0.29,0.29,0.29,0.63,0.97,1.12,1.12,1.66,1.66,1.41,1.4,1.38,1.37,1.35,1.35,1.31,1.28,1.28,1.41,1.41,1.42,1.44,1.46,1.49,1.71,1.94,2.39,2.83,2.64,2.47,2.29,1.84,1.39,0.93,0.47,0.27,0.38,0.48,0.64,0.81,0.78,0.76,1.47,2.17,2.17,0.42,0.42,0.98,1.54,1.48,1.74,2.01,1.77,1.53,1.02,0.5,0.51,0.52,0.51,0.5,0.46,0.43,0.45,0.48,1.46,2.43,3.27,4.1,3.03,1.97,1.74,1.87,1.99,1.95,2.16,2.36,2.66,2.95,2.41,1.87,1.77,1.68,2.05,2.43,2.59,3.27,3.95,2.62,1.3,1.21,1.24,1.27,1.32,1.85,2.39,1.89,1.39,1.39,1.52,1.65,1.37,1.04,0.72:2
1.62,1.44,1.24,1.05,1.15,1.24,1.34,1.2,1.07,1.53,1.99,2.13,2.27,2.29,1.77,1.25,1.19,1.12,1.24,1.36,1.16,1.22,1.27,1.35,1.31,1.26,1.22,1.18,1.15,1.16,1.17,1.18,1.19,1.24,1.25,1.4,1.54,1.81,2.09,1.7,1.32,1.3,1.16,1.03,1.03,1.07,1.11,1.19,1.26,1.37,1.48,1.92,2.36,2.41,2.47,2.34,1.86,1.38,1.74,2.09,2.2,2.25,2.24,2.13,2.01,1.87,1.78,1.69,2.38,3.08,3.07,3.06,3.14,3.21,3.1,2.99,2.33,1.68,1.59,2.01,2.42,2.42,4.11,4.11,3.65,2.66,1.68,1.64,1.56,1.48,1.95,2.41,2.27,1.53,0.8,0.85,1.29,1.73,1.53,1.39,1.21,1.03,0.82,0.61,2.68,4.75,4.18,3.62,3.6,3.58,3.26,2.93,3.04,3.96,4.89,4.8,5.41,6.03,5.29,4.54,3.71,5.01,6.32,7.3,7.28,7.26,6.83,6.41,5.71,5.58,5.45,4.8,4.15,4.15,1.43,1.43,1.4,1.34,1.29,0.89,0.5,0.38,0.3,0.21:2
0.22,0.33,0.29,0.25,0.25,0.29,0.26,0.23,0.24,0.28,0.28,0.28,0.29,0.28,0.27,0.27,0.25,0.27,0.29,0.28,0.26,0.29,0.3,0.3,0.25,0.25,0.8,1.35,1.18,1.0,0.67,0.34,0.3,0.3,0.3,0.3,0.26,0.27,0.29,0.3,1.84,3.38,3.12,2.85,2.75,3.02,3.29,2.9,2.5,2.06,1.61,1.6,1.6,1.57,1.54,1.54,1.51,1.49,1.5,1.51,1.51,1.52,1.56,1.54,1.52,1.49,1.52,1.52,1.51,1.5,1.53,1.55,1.56,1.4,1.24,1.02,0.79,0.59,0.47,0.46,0.46,0.46,0.47,0.5,0.48,0.46,0.44,0.45,0.45,0.45,0.44,0.45,0.49,0.5,0.48,0.46,0.47,0.45,0.44,0.44,0.47,0.48,0.63,0.78,0.78,2.18,2.18,2.66,3.13,3.23,3.34,3.12,2.91,2.71,2.51,2.73,2.95,2.95,1.01,1.01,1.5,1.99,2.43,2.88,3.12,3.35,3.69,4.03,2.88,1.73,2.41,3.08,1.99,0.89,0.85,0.82,0.69,0.56,0.44,0.42,0.41,0.41,0.38,0.33:2
3.57,5.24,5.71,6.18,5.24,4.31,4.31,4.08,3.85,3.71,3.56,3.33,3.09,2.73,2.37,2.12,1.88,1.93,1.99,1.96,1.92,1.88,1.94,2.01,1.93,1.85,1.85,1.92,1.92,1.88,1.83,1.92,1.93,1.94,2.07,2.19,2.67,3.15,3.05,2.96,2.58,2.19,1.85,1.79,1.73,1.78,1.84,1.91,1.98,2.08,2.19,2.18,2.17,2.21,2.26,2.24,2.44,2.64,3.24,3.84,3.95,4.06,2.84,1.63,1.48,1.34,1.06,0.79,1.09,1.39,1.39,1.45,1.39,1.32,1.32,1.98,2.64,2.65,2.67,2.2,1.74,1.59,1.51,1.44,1.47,1.5,1.5,1.42,1.42,1.42,1.42,1.45,2.14,2.83,2.46,2.08,2.28,3.36,4.43,4.25,4.06,3.61,3.17,2.79,2.31,1.83,2.0,2.18,2.19,2.21,2.15,2.27,2.39,3.16,3.94,3.75,3.55,2.95,2.35,2.2,2.06,2.45,2.85,3.11,3.3,3.5,3.43,2.86,2.28,2.28,1.64,1.64,1.64,1.62,1.62,1.6,1.59,1.59,3.09,3.09,2.88,2.88,0.41,0.41:2
0.94,1.09,1.07,1.17,1.23,1.39,1.3,1.15,0.99,0.91,0.97,0.98,0.96,0.95,1.01,1.22,1.28,1.24,1.24,1.23,1.39,1.35,1.3,1.29,1.36,1.72,1.87,2.07,1.98,1.94,1.88,1.73,1.38,1.23,1.18,1.06,0.92,0.99,0.87,0.94,0.84,0.85,0.95,0.88,0.94,0.82,0.92,0.9,0.83,0.98,1.32,1.67,1.51,1.38,1.52,1.46,1.4,1.14,1.09,1.11,1.61,2.16,2.72,3.28,2.99,2.7,2.41,2.21,2.2,2.1,2.13,2.01,2.95,3.89,3.1,3.8,4.5,4.67,4.43,3.64,2.81,2.37,2.2,2.32,2.35,2.49,2.48,2.39,2.54,2.47,2.27,1.48,1.99,2.49,2.39,2.06,1.67,1.57,1.45,1.42,1.65,2.02,2.17,2.13,2.21,2.35,2.66,2.77,2.84,2.6,2.62,2.64,2.65,2.67,2.91,3.46,3.58,3.06,2.15,2.01,2.69,3.45,3.85,3.64,3.43,3.07,3.13,3.49,3.09,2.14,1.3,1.01,0.78,0.54,0.37,0.28,0.28,0.29,0.29,0.26,0.27,0.28,0.29,0.28:2
0.26,0.28,0.31,0.29,0.27,0.27,0.28,0.28,0.28,0.3,0.32,0.31,0.32,0.32,0.3,0.28,0.3,0.32,0.28,0.24,0.27,0.31,0.23,0.84,1.46,1.15,0.85,0.62,0.4,0.37,0.3,0.23,0.27,0.31,0.27,0.3,0.32,0.31,0.3,1.22,2.14,2.38,2.62,2.36,2.04,1.72,2.06,2.4,2.68,2.3,1.91,2.34,2.52,2.7,2.04,1.38,1.46,1.42,1.37,1.37,2.17,2.17,1.74,1.32,1.36,1.41,1.35,1.33,1.32,1.38,1.38,1.31,1.38,1.38,1.35,1.33,1.35,1.37,1.51,1.66,1.39,1.12,1.62,2.12,2.05,1.98,1.78,1.59,1.4,1.4,1.44,1.4,1.4,1.41,1.42,1.45,0.85,0.26,0.65,1.04,1.27,1.5,1.6,1.7,1.73,1.75,1.76,1.93,2.09,2.31,2.52,2.6,2.68,2.52,2.75,2.98,2.95,2.91,2.91,3.27,3.27,3.18,3.09,3.1,3.1,3.09,2.75,2.41,2.38,1.78,1.17,1.03,0.82,0.61,0.52,0.43,0.39,0.36,0.35,0.35,0.33,0.31,0.34,0.37:2
3.58,3.4,3.22,3.15,3.15,2.86,2.86,2.86,0.38,0.38,0.37,0.39,0.41,0.77,1.13,1.13,0.26,0.26,0.26,0.32,0.31,0.33,0.36,0.34,0.33,0.29,0.26,0.31,0.35,0.3,0.26,0.32,0.32,0.32,0.29,0.26,0.28,0.31,0.31,0.34,0.34,0.31,0.28,0.29,0.3,0.3,0.3,0.26,0.53,0.8,1.07,1.34,1.34,0.72,0.72,0.55,0.37,0.42,0.49,0.56,1.05,1.55,2.01,1.92,1.82,1.82,1.75,1.75,1.86,1.97,2.42,2.87,2.76,2.66,2.58,2.5,1.95,1.41,1.16,0.92,0.73,0.54,0.59,0.65,1.08,1.5,1.12,0.73,0.48,0.39,0.31,0.3,0.35,0.39,0.39,0.55,0.71,1.05,1.05,3.15,3.15,2.76,2.36,2.18,1.99,1.99,1.98,1.75,1.52,1.57,1.61,3.0,4.38,4.46,4.53,4.21,3.88,3.31,2.74,3.12,3.5,4.11,4.72,4.2,3.68,3.67,3.16,2.66,2.54,2.42,2.88,3.35,2.4,1.46,1.54,1.63,1.59,1.13,0.67,0.49,0.31,0.27,0.3,0.32:2
1.49,1.29,1.1,0.71,0.33,0.28,0.23,0.27,0.3,0.32,0.33,0.33,0.32,0.3,0.28,0.3,0.29,0.27,0.27,0.27,0.27,0.27,0.27,0.3,0.33,0.34,0.32,0.33,0.33,0.29,0.24,0.27,0.32,0.31,0.3,0.3,0.3,0.26,0.23,0.25,0.31,0.41,0.79,1.18,1.14,1.1,1.5,1.9,2.22,1.96,1.7,1.58,1.62,1.66,1.49,1.32,1.34,1.37,1.37,1.37,1.36,1.36,1.35,1.32,1.28,1.37,1.46,1.42,1.37,2.64,3.91,3.89,2.67,1.46,0.92,0.38,0.39,0.37,0.35,0.37,0.38,0.35,0.32,0.33,0.33,1.42,1.42,0.91,0.4,0.44,0.47,0.42,1.64,2.86,1.57,0.27,0.26,0.3,0.33,0.32,0.31,0.34,0.36,0.36,0.52,0.52,0.57,0.61,0.79,0.96,0.96,2.1,2.1,2.04,1.99,2.79,3.59,4.31,5.02,4.87,4.74,3.54,2.34,2.84,3.34,3.3,3.25,2.96,2.92,2.89,3.13,3.01,2.9,2.88,3.12,3.36,3.36,1.61,1.61,1.41,0.89,0.37,0.71,1.05:2
0.33,0.3,0.32,0.43,0.49,0.55,0.57,0.44,0.3,0.27,0.3,0.35,0.39,0.36,0.37,0.4,0.4,0.36,0.31,0.32,0.31,0.3,0.32,0.3,0.3,0.31,0.32,0.3,0.25,0.56,0.86,1.09,1.32,1.21,1.11,0.72,0.33,0.65,0.98,1.57,3.09,4.61,3.43,2.25,2.26,2.27,2.06,1.85,1.82,1.6,1.39,1.36,1.37,1.41,1.43,1.42,1.41,1.44,1.46,1.37,1.35,1.39,1.39,1.35,1.35,1.39,1.4,1.36,1.36,1.37,1.39,1.38,1.39,1.38,1.4,1.43,1.47,1.48,1.45,1.41,1.42,1.47,0.86,0.26,0.28,0.29,0.31,0.29,0.31,0.35,0.34,0.31,0.31,0.32,0.32,0.33,0.38,0.44,0.45,0.47,0.51,0.54,0.49,0.51,0.53,0.5,0.38,0.26,0.37,0.49,0.85,1.22,2.38,3.54,3.12,2.71,2.71,5.53,5.53,4.88,4.58,4.28,3.86,3.49,3.12,3.02,2.94,2.9,2.95,2.99,2.94,2.89,2.86,2.81,2.62,2.36,2.04,1.89,1.75,1.7,1.67,1.65,1.63,1.63:2
0.41,0.34,0.29,0.23,0.27,0.32,0.25,0.24,0.28,0.32,0.32,0.29,0.33,0.36,0.31,0.26,0.24,0.27,0.27,0.27,0.28,0.31,0.33,0.31,0.26,0.23,0.24,0.25,0.27,0.25,0.25,0.31,0.37,0.3,0.22,0.23,0.27,0.31,0.25,0.25,0.29,1.96,3.63,2.88,2.13,2.19,1.95,1.71,1.71,1.71,1.6,1.5,1.05,0.6,0.5,0.41,0.37,0.34,0.78,1.21,1.43,1.4,1.37,1.36,1.35,1.32,1.32,1.33,1.33,1.34,1.32,1.31,1.33,1.35,1.32,1.31,1.33,1.37,1.42,1.42,1.42,1.42,1.46,1.47,1.48,1.55,1.32,1.09,0.79,0.48,0.52,0.55,0.56,0.57,0.58,0.56,0.53,0.52,0.55,0.61,0.68,0.69,0.69,0.69,0.7,0.72,1.01,1.3,1.53,1.93,2.33,2.34,2.36,2.36,3.36,3.36,4.49,5.62,5.62,6.04,6.04,4.43,2.81,3.35,3.89,3.35,2.81,2.67,2.54,2.59,2.64,2.78,2.92,2.92,2.36,2.36,2.06,1.76,0.96,0.96,1.36,1.36,0.88,0.39:2
0.27,0.25,0.27,0.34,0.36,0.34,0.32,0.3,0.29,0.27,0.28,0.27,0.27,0.26,0.29,0.3,0.27,0.25,0.28,0.34,0.35,0.32,0.3,0.32,0.33,0.26,0.26,0.33,0.45,0.57,0.57,0.58,0.57,0.78,1.0,1.16,1.33,1.22,0.88,0.55,1.66,2.77,1.24,1.62,2.0,2.1,2.19,2.49,2.12,1.75,1.62,1.49,1.6,1.71,1.71,1.72,1.55,1.39,1.43,1.42,1.37,1.31,1.31,1.37,1.37,1.32,1.3,1.33,1.35,1.35,1.3,1.31,1.35,1.37,1.36,1.38,1.43,1.25,1.07,0.67,0.27,0.28,0.26,0.26,0.29,0.31,0.28,0.25,0.25,0.29,0.32,0.37,0.57,0.77,0.71,0.66,0.64,0.65,0.65,0.64,0.65,0.69,1.33,1.97,1.87,1.76,1.64,1.61,1.61,1.61,1.6,1.73,1.86,1.91,1.93,1.93,2.76,3.6,3.58,3.57,3.27,2.97,2.91,3.17,3.42,3.57,3.57,2.17,2.17,1.99,1.81,1.63,1.45,1.45,2.73,4.01,2.76,1.51,1.45,1.1,0.76,0.57,0.39,0.46:2
1.37,1.34,1.32,1.36,1.4,1.37,1.37,1.37,1.36,1.35,1.33,1.31,0.82,0.34,0.33,0.32,0.31,0.31,0.29,0.27,0.25,0.23,0.23,0.24,0.24,0.28,0.28,0.33,0.33,0.33,0.29,0.25,0.25,0.27,0.22,0.22,0.23,0.25,0.25,0.3,0.3,0.28,0.76,1.25,1.65,2.06,2.33,2.6,2.94,2.88,2.82,2.3,2.6,2.9,2.11,1.32,1.32,1.35,1.39,1.42,1.45,1.99,2.53,1.93,1.33,1.34,1.35,1.35,1.36,1.37,1.38,1.42,1.45,1.44,1.42,1.03,0.64,0.58,0.53,0.53,0.54,0.54,0.55,0.56,0.79,1.02,1.45,1.88,1.81,1.75,1.63,1.52,1.62,1.65,1.68,1.64,1.61,1.66,1.72,1.54,1.36,1.36,1.36,1.66,1.95,1.94,1.93,1.99,2.34,2.68,2.56,2.45,1.93,1.4,1.37,2.3,3.23,3.23,3.66,3.66,3.36,3.06,2.91,2.76,2.39,2.01,1.72,1.61,1.49,1.45,1.41,1.52,1.69,1.86,1.92,1.97,1.9,2.1,2.31,2.65,3.0,3.0,1.77,1.77:2
0.4,0.4,0.3,0.3,0.3,0.29,0.28,0.28,0.21,0.21,0.23,0.25,0.3,0.3,0.17,0.17,0.22,0.3,0.39,0.32,0.24,0.25,0.31,0.37,0.26,0.23,0.2,0.24,0.27,0.23,0.23,0.24,0.24,0.27,0.27,0.26,0.24,0.24,0.29,0.34,0.31,0.28,0.3,0.32,0.32,1.72,1.72,1.59,1.45,1.38,1.31,1.31,1.31,1.38,1.44,1.9,2.35,2.15,1.95,1.73,1.73,3.54,3.54,3.25,3.0,2.74,3.03,2.81,2.58,2.11,1.65,1.63,1.6,1.53,3.0,4.47,3.76,3.04,3.02,3.01,2.3,1.58,2.56,3.53,3.32,3.32,1.94,1.94,3.26,4.59,3.35,2.11,1.78,1.41,1.05,0.7,0.36,0.42,0.39,0.36,0.39,0.43,0.39,0.6,0.81,2.77,4.73,5.11,3.41,1.71,1.71,2.36,2.36,1.95,1.54,1.54,2.58,3.62,4.01,4.41,4.43,4.45,4.28,3.9,3.53,2.9,2.32,1.75,1.36,0.96,0.87,0.79,0.74,0.7,0.57,0.44,0.41,0.37,0.37,0.37,0.46,0.55,0.75,0.95:2
1.44,1.46,1.47,1.41,1.44,1.47,1.44,1.39,1.34,1.25,1.15,0.7,0.24,0.24,0.35,0.35,0.34,0.33,0.31,0.3,0.28,0.28,0.3,0.3,0.27,0.24,0.24,0.24,0.34,0.34,0.34,0.29,0.29,0.31,0.33,0.29,0.24,0.29,0.28,0.26,0.23,0.23,0.33,0.26,0.26,0.51,0.76,0.71,0.67,1.44,2.2,2.7,3.64,4.57,5.42,5.42,3.46,3.46,2.37,1.28,0.97,0.66,1.34,2.02,1.62,1.22,1.33,1.49,1.66,2.09,2.52,2.45,2.46,2.46,2.46,3.71,3.71,3.17,2.54,1.92,1.8,1.88,1.97,2.11,3.14,4.16,3.11,2.06,2.06,1.99,1.99,2.48,2.98,2.98,1.65,1.65,1.31,0.98,1.07,1.66,2.25,2.7,3.49,4.28,4.02,3.76,3.75,3.51,3.26,2.38,1.5,1.51,1.52,1.56,1.56,1.56,1.56,1.49,1.53,1.53,1.52,1.51,1.51,1.52,1.52,1.56,1.55,1.54,1.56,1.57,1.57,1.49,1.49,1.49,1.06,0.62,0.5,0.49,0.49,0.45,0.41,0.77,1.13,1.62:2
0.19,0.2,0.17,0.19,0.24,0.27,0.22,0.19,0.18,0.49,0.92,1.24,0.86,0.49,0.39,0.29,0.24,0.21,0.2,0.19,0.16,0.16,0.2,0.19,0.14,0.12,0.19,0.25,0.18,0.17,0.17,0.17,0.14,0.18,0.19,0.16,0.17,0.24,0.26,0.2,0.17,0.41,0.64,0.5,0.36,0.35,0.35,1.46,1.46,1.93,1.59,1.25,1.29,1.27,1.17,1.07,0.59,0.11,0.17,0.25,0.26,0.2,0.17,0.17,0.16,0.16,0.18,0.16,0.49,0.82,0.6,0.39,0.31,0.56,0.81,1.1,1.38,1.35,1.37,1.14,0.9,0.65,0.4,0.28,0.17,0.14,0.18,0.19,0.17,0.17,0.18,0.21,0.24,0.26,0.2,0.17,0.19,0.2,0.16,0.15,0.2,0.21,0.19,0.22,0.26,0.23,0.18,0.17,0.22,0.26,0.29,2.31,4.33,3.41,2.5,2.83,2.48,2.12,2.4,2.69,1.7,0.72,1.18,1.65,1.65,1.89,1.89,2.12,2.35,1.83,1.31,2.41,3.51,3.51,2.91,2.91,2.96,3.02,2.13,1.31,0.49,0.38,0.33,0.34:2
0.32,0.38,0.41,0.37,0.33,0.32,0.33,0.32,0.31,0.32,0.33,0.34,0.34,0.33,0.32,0.29,0.28,0.27,0.28,0.27,0.26,0.26,0.27,0.27,0.27,0.27,0.28,0.29,0.3,0.31,0.32,0.33,0.33,0.45,0.57,0.99,1.41,1.17,0.92,0.83,0.78,0.73,0.69,0.66,1.38,2.11,2.67,2.34,2.01,2.11,2.3,2.5,2.3,2.1,1.79,1.57,1.36,1.38,1.4,1.4,1.36,1.33,1.36,1.44,1.51,1.51,1.5,1.62,1.75,1.63,1.5,1.38,1.35,1.32,1.33,1.36,1.36,1.36,1.38,1.43,1.48,1.53,1.53,2.99,2.99,2.18,1.36,1.4,1.85,2.3,1.92,1.54,1.58,1.54,1.51,1.46,1.41,1.41,1.41,1.37,1.38,1.38,1.36,1.32,1.34,1.35,1.6,1.84,1.93,2.01,1.9,1.78,1.58,1.38,1.53,1.9,2.28,2.45,2.61,2.73,2.84,2.85,2.86,2.78,2.42,2.07,1.96,1.86,1.82,1.82,3.07,3.07,2.87,2.62,2.31,1.92,1.54,1.56,1.61,1.5,1.39,1.38,1.42,1.46:2
1.84,1.29,0.73,0.71,0.7,0.7,0.5,0.31,0.27,0.23,0.24,0.26,0.29,0.29,0.29,0.29,0.33,0.33,0.33,0.34,0.34,0.29,0.24,0.3,0.3,0.3,0.3,0.25,0.25,0.24,0.26,0.28,0.28,0.31,0.31,0.61,0.91,1.13,1.35,1.21,1.07,0.67,0.27,0.92,1.57,1.59,1.46,1.33,1.37,1.75,2.12,2.25,2.08,1.92,1.67,1.42,1.35,1.27,1.38,1.33,1.29,1.32,1.35,1.37,1.38,1.42,1.46,1.46,1.45,1.41,1.47,1.53,1.58,1.89,2.19,1.95,1.71,1.64,1.57,2.04,2.52,2.18,1.85,1.56,1.76,1.96,1.96,2.4,2.4,2.4,1.71,1.71,1.64,1.58,1.68,1.78,1.62,1.47,1.47,1.43,1.41,1.41,1.43,1.46,1.88,2.3,2.42,2.42,2.43,2.4,2.08,1.76,1.66,1.55,1.58,1.58,3.44,3.44,2.85,3.22,3.58,3.34,3.11,2.7,2.62,2.53,2.08,1.63,1.61,1.58,1.46,1.34,1.2,0.88,0.57,0.48,0.38,0.39,0.39,0.33,0.26,0.33,0.28,0.24:2
1.43,1.31,1.19,0.79,0.4,0.34,0.32,0.29,0.31,0.33,0.34,0.35,0.31,0.26,0.31,0.35,0.31,0.27,0.27,0.38,0.38,0.34,0.3,0.3,0.34,0.28,0.32,0.32,0.33,0.33,0.29,0.31,0.34,0.32,0.3,0.33,0.37,0.44,0.44,2.22,2.22,2.0,1.83,1.66,1.8,1.95,2.34,2.07,1.8,2.76,3.73,2.77,1.82,1.58,1.35,1.38,1.84,2.3,2.3,1.41,1.41,1.43,1.44,3.02,4.59,3.75,2.9,2.07,1.23,1.74,2.88,4.03,3.79,3.54,3.34,3.27,3.19,3.19,3.12,3.05,2.91,2.77,2.12,1.46,0.95,0.43,0.35,0.27,0.32,0.39,0.46,0.37,0.27,0.27,0.38,0.34,0.36,0.36,0.35,0.37,0.32,0.32,0.36,0.4,0.36,0.32,0.32,0.35,0.39,0.42,1.71,2.99,3.09,2.99,2.9,2.74,2.59,2.48,2.37,2.31,2.25,2.18,2.11,2.03,2.03,2.24,2.45,2.36,2.26,2.09,1.92,1.7,1.47,0.92,0.6,0.28,0.34,0.28,0.23,0.26,0.29,0.32,0.35,0.22:2
0.23,0.23,0.22,0.2,0.19,0.21,0.25,0.29,0.26,0.26,0.29,0.28,0.24,0.25,0.23,0.19,0.18,0.21,0.2,0.19,0.19,0.2,0.2,0.21,0.22,0.27,0.29,0.26,0.25,0.28,0.29,0.56,0.97,1.23,1.14,1.0,0.59,0.18,0.21,0.18,0.19,0.21,0.23,0.22,0.76,1.14,0.88,0.37,0.32,0.31,0.32,0.27,0.12,0.56,0.99,1.38,1.35,1.31,1.29,1.27,1.24,1.27,1.09,0.91,0.62,0.33,0.37,0.38,0.35,0.32,0.32,0.32,0.3,0.3,0.32,0.57,0.83,1.06,1.3,0.96,0.62,0.56,0.56,0.55,0.5,0.44,0.43,0.39,0.36,0.37,0.74,1.11,0.71,0.31,0.24,0.25,0.3,0.3,0.29,0.33,0.37,0.34,0.24,0.24,1.54,1.54,1.5,1.73,1.97,2.14,2.26,2.82,3.38,2.78,2.2,1.95,1.94,1.94,1.9,1.88,1.64,1.39,1.14,0.89,0.79,0.67,0.73,0.8,0.87,1.32,1.78,1.65,1.65,1.03,1.03,1.64,2.26,1.71,1.09,0.31,0.31,0.27,0.21,0.19:2
1.31,0.73,0.15,0.21,0.27,0.25,0.23,0.26,0.29,0.26,0.23,0.22,0.22,0.19,0.17,0.19,0.21,0.2,0.18,0.19,0.21,0.22,0.23,0.26,0.28,0.28,0.28,0.24,0.21,0.19,0.17,0.18,0.19,0.21,0.19,0.17,0.19,0.19,0.18,0.18,1.56,1.56,1.56,1.26,1.26,1.6,1.93,2.62,3.32,2.27,1.23,1.97,2.72,1.93,1.14,1.21,1.29,1.03,0.78,0.53,0.29,0.23,0.16,0.18,0.19,0.17,0.14,0.17,0.19,0.19,0.19,0.19,0.19,0.19,0.24,0.24,0.28,0.28,0.26,0.25,0.23,0.21,0.17,0.14,0.17,0.21,0.12,0.18,0.24,0.26,0.22,0.18,0.28,0.25,0.22,0.25,0.27,0.23,0.19,0.2,0.22,0.19,0.18,0.17,0.18,0.19,0.16,0.19,0.23,0.21,0.2,0.93,1.65,2.68,3.7,3.31,2.92,3.47,4.01,3.3,2.6,1.82,1.04,1.29,1.54,3.56,5.57,6.32,7.07,6.09,5.11,4.8,4.5,3.93,3.35,2.45,1.55,1.43,1.3,1.3,1.31,1.34,1.07,0.81:2
2.8,2.27,1.73,1.65,1.57,2.01,2.45,2.52,2.59,2.54,2.59,2.65,2.54,2.43,2.19,1.96,1.6,1.47,1.35,1.36,1.3,1.23,1.23,1.23,1.22,1.16,1.09,1.15,1.2,1.19,1.17,1.22,1.18,1.14,1.1,1.06,0.91,0.75,0.53,0.47,0.41,0.38,0.29,0.21,0.25,0.24,0.24,0.25,0.26,0.45,0.65,0.85,1.05,1.33,1.61,1.11,0.6,0.6,0.54,0.47,0.57,0.47,0.38,0.43,0.43,1.95,1.95,2.01,2.07,1.9,1.74,2.17,2.61,2.67,2.73,2.86,3.26,3.67,3.75,2.93,2.11,3.13,4.15,4.15,3.7,3.7,3.83,3.83,2.67,2.67,2.78,2.89,4.81,6.74,5.46,4.18,4.11,4.2,4.28,4.28,4.36,4.36,3.76,2.74,1.72,1.67,1.63,1.72,1.81,2.05,2.29,2.59,2.89,2.87,2.85,2.84,2.84,2.83,2.82,2.44,2.06,1.8,1.55,1.94,2.33,3.08,3.83,3.69,3.56,3.29,3.02,2.55,2.22,1.89,1.27,0.64,0.64,0.58,0.56,0.47,0.44,0.46,0.46,0.47:2
0.35,0.34,0.31,0.35,0.38,0.35,0.31,0.27,0.28,0.3,0.32,0.29,0.32,0.35,0.35,0.32,0.26,0.27,0.31,0.31,0.27,0.26,0.31,0.52,0.72,1.03,1.34,1.1,0.86,0.55,0.23,0.31,0.33,0.32,0.3,0.31,0.29,0.28,0.26,0.27,1.1,1.94,1.75,1.56,2.0,2.0,3.15,3.15,2.82,2.48,1.58,1.58,2.45,2.45,1.93,1.4,0.92,0.64,0.35,0.32,0.31,0.32,0.34,0.35,0.35,0.36,0.35,0.34,0.32,0.31,0.33,0.34,0.33,0.31,0.31,0.32,0.34,0.33,0.33,0.34,0.35,0.35,3.01,3.01,2.51,2.01,1.84,1.84,2.42,2.42,3.12,3.82,4.45,5.08,5.62,6.16,4.95,3.74,3.59,3.45,3.45,4.86,4.86,3.7,2.55,2.89,2.9,2.91,2.99,3.15,3.36,3.41,3.45,3.25,3.05,2.7,2.44,2.18,1.9,1.62,2.09,2.55,2.68,2.81,2.86,2.91,2.8,2.69,2.71,2.72,2.62,2.62,0.86,0.86,0.67,0.49,0.51,0.5,0.44,0.39,0.38,0.35,0.32,0.29:2
0.77,1.06,1.36,1.28,1.2,0.78,0.37,0.37,0.27,0.27,0.25,0.22,0.23,0.21,0.19,0.23,0.22,0.22,0.21,0.21,0.24,0.25,0.26,0.26,0.28,0.28,0.28,0.27,0.27,0.22,0.17,0.16,0.16,0.16,0.16,0.16,0.15,0.14,0.14,0.25,0.25,0.25,0.26,0.3,0.34,0.45,0.55,0.9,1.25,0.97,0.7,0.48,0.27,0.18,0.34,0.5,0.29,0.5,0.71,1.08,1.45,1.4,1.35,1.35,1.35,1.35,1.85,2.35,1.86,1.36,1.41,1.45,0.99,0.52,0.36,0.19,0.25,0.31,0.31,0.38,0.28,0.28,0.33,0.39,1.1,1.82,2.39,2.97,1.74,0.5,0.51,0.81,1.12,0.67,0.21,0.7,1.19,1.26,1.33,1.48,1.63,1.63,0.65,0.65,0.56,0.47,0.44,0.67,0.91,0.89,0.87,0.8,0.72,2.01,3.31,3.88,4.44,3.86,3.34,2.82,2.16,1.5,1.07,0.63,0.63,0.41,0.41,0.49,0.57,0.62,1.16,1.7,1.68,1.65,1.58,1.5,1.34,1.18,0.85,0.52,0.45,0.36,0.27,0.31:2
0.38,0.39,0.4,0.37,0.33,0.34,0.34,0.37,0.41,0.36,0.31,0.4,0.48,0.95,1.42,1.42,1.99,2.55,2.49,2.43,2.45,2.45,2.45,2.45,2.46,2.46,2.43,2.4,2.38,2.35,2.39,2.44,2.4,2.35,2.37,2.38,2.39,2.42,2.45,2.52,2.59,2.5,2.93,3.35,3.53,3.71,2.53,1.35,1.65,1.95,2.45,2.95,2.41,1.87,1.93,1.98,2.04,1.98,1.92,3.34,4.76,5.9,5.54,5.17,4.45,3.72,3.72,1.49,1.49,1.51,1.54,1.53,1.52,1.52,1.56,1.56,1.48,1.4,1.43,1.46,1.45,1.69,1.93,1.88,1.82,2.03,2.24,2.24,2.12,2.12,1.94,1.76,2.51,3.25,3.34,3.43,3.43,1.71,1.71,1.78,1.85,1.83,1.82,1.77,1.71,1.65,2.73,3.82,3.77,3.73,4.16,4.59,3.99,3.38,3.56,3.74,3.75,3.73,3.72,4.39,4.8,5.21,4.86,4.52,4.19,4.19,2.39,2.39,2.36,2.33,2.47,2.62,2.63,2.54,2.45,2.22,1.98,1.98,2.06,2.13,2.23,2.5,2.77,3.42:2
0.25,0.29,0.33,0.33,0.32,0.34,0.35,0.35,0.34,0.29,0.23,0.16,0.22,0.29,0.24,0.19,0.16,0.2,0.24,0.24,0.23,0.19,0.17,0.19,0.23,0.27,0.19,0.12,0.21,0.3,0.28,0.76,1.23,1.28,0.78,0.28,0.27,0.25,0.23,0.22,0.23,0.5,0.77,0.44,0.12,0.16,0.21,0.2,0.24,0.28,0.48,0.67,0.99,1.32,1.2,1.11,1.02,0.93,0.85,2.0,3.14,2.88,2.24,1.61,1.5,1.39,1.47,1.55,1.59,1.61,1.64,1.61,1.59,1.6,1.61,1.61,1.64,1.67,1.82,1.96,2.01,2.06,1.87,1.68,1.49,1.29,1.53,1.67,1.81,1.89,1.98,1.75,1.52,2.49,2.49,1.03,1.03,1.0,0.97,1.74,2.52,2.51,2.49,3.28,4.07,2.6,1.12,1.56,1.99,2.19,2.39,2.38,2.92,3.47,3.47,2.42,2.42,2.42,3.15,3.15,3.17,3.18,3.38,3.33,3.28,2.95,2.62,2.47,2.32,1.77,1.23,1.17,1.32,1.47,1.23,0.98,0.99,1.0,1.26,1.52,1.79,1.95,2.1,2.05:2
0.34,0.31,0.32,0.34,0.33,0.31,0.35,0.39,0.38,0.37,0.34,0.31,0.31,0.31,0.31,0.32,0.32,0.29,0.29,0.32,0.35,0.37,0.37,0.33,0.33,0.29,0.31,0.34,0.32,0.3,0.23,0.77,1.31,1.38,1.07,0.76,0.43,0.68,0.94,1.47,2.89,4.3,3.23,2.16,2.28,2.4,2.22,2.04,1.73,1.43,1.37,1.31,1.38,1.35,1.33,1.35,1.36,1.36,1.36,1.37,1.38,1.01,0.64,0.46,0.28,0.3,0.32,0.32,0.25,0.31,0.29,0.29,0.3,0.3,0.39,0.35,0.31,0.3,0.3,0.3,0.3,0.29,0.28,0.31,0.33,0.32,0.31,0.27,0.32,0.37,0.32,0.31,0.29,0.29,0.31,0.31,0.33,0.34,0.32,0.3,0.32,0.34,0.35,0.37,0.35,0.56,0.78,1.22,1.67,1.66,1.66,1.73,2.01,2.28,2.35,2.41,2.47,2.55,2.64,2.74,2.83,2.66,2.88,3.09,3.47,3.89,4.32,3.59,2.85,2.87,2.77,2.68,2.49,3.14,3.8,3.8,1.43,1.43,1.4,1.37,1.43,0.87,0.31,0.25:2
0.29,0.29,0.29,0.3,0.3,0.31,0.31,0.31,0.31,0.29,0.28,0.26,0.25,0.26,0.27,0.25,0.24,0.26,0.29,0.3,0.3,0.3,0.29,0.27,0.26,0.28,0.31,0.29,0.27,0.23,0.23,1.45,1.45,1.35,0.92,0.49,0.36,0.24,0.28,0.31,0.38,0.72,1.06,0.95,0.84,1.24,1.64,1.85,2.06,1.7,1.35,1.36,1.51,1.66,1.73,1.79,1.82,1.85,1.85,1.85,1.86,1.63,1.41,1.4,1.39,1.33,1.4,1.47,1.47,1.46,1.42,1.38,1.98,2.59,1.97,1.35,1.33,1.32,1.32,1.84,1.84,1.71,1.58,1.64,1.7,1.66,1.51,1.37,1.38,1.39,1.43,1.5,1.49,1.48,1.45,1.46,1.46,1.75,2.04,1.91,1.78,1.57,1.36,1.46,1.56,1.7,1.83,1.95,2.06,2.04,2.01,2.36,2.7,2.96,3.23,3.39,3.54,2.78,2.03,2.38,2.74,2.86,2.97,3.4,3.83,2.77,2.07,1.37,1.43,1.49,1.41,1.71,2.01,1.28,0.54,0.7,0.85,0.86,0.87,1.09,1.31,1.44,1.56,1.5:2
0.32,0.37,0.31,0.26,0.3,0.34,0.32,0.31,0.31,0.31,0.31,0.32,0.32,0.27,0.28,0.28,0.32,0.31,0.3,0.3,0.29,0.3,0.32,0.28,0.24,0.31,0.39,0.3,0.22,0.25,0.28,0.31,0.3,0.29,0.31,0.32,0.69,1.06,1.35,0.87,0.39,0.62,0.85,0.79,0.73,0.82,0.92,1.28,1.65,1.92,2.9,3.88,2.24,0.6,1.24,1.88,1.64,0.94,0.25,0.28,0.29,0.31,0.28,0.36,0.44,0.38,0.31,0.31,0.23,0.31,0.31,0.31,0.42,0.42,0.44,0.45,0.91,1.36,1.39,1.12,0.86,0.58,0.31,0.35,0.4,0.42,0.44,0.46,0.41,0.36,0.34,0.31,0.36,0.4,0.37,0.34,0.32,0.27,0.23,0.25,0.28,0.31,0.34,0.28,0.23,0.27,0.31,0.22,0.29,0.36,0.33,0.29,0.41,0.53,0.53,1.32,2.12,2.17,2.22,3.42,4.62,3.11,1.61,2.33,2.33,4.54,4.54,4.15,3.77,3.3,3.3,0.64,0.64,0.67,0.77,0.88,0.78,0.68,0.53,0.39,0.38,0.37,0.34,0.31:1
0.26,0.24,0.22,0.17,0.16,0.18,0.2,0.2,0.22,0.26,0.27,0.22,0.19,0.2,0.19,0.16,0.15,0.19,0.19,0.16,0.15,0.2,0.22,0.22,0.24,0.27,0.24,0.19,0.17,0.19,0.17,0.15,0.18,0.19,0.16,0.16,0.22,0.34,0.76,1.18,1.56,1.94,1.41,0.89,0.88,0.88,0.63,0.38,0.28,0.2,0.16,0.17,0.24,0.25,0.23,0.23,0.23,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.18,0.16,0.16,0.2,0.25,0.23,0.22,0.2,0.18,0.16,0.17,0.17,0.16,0.17,0.22,0.32,0.42,0.5,0.55,0.52,0.44,0.39,0.35,0.27,0.18,0.15,0.19,0.22,0.22,0.78,1.34,1.34,1.3,1.3,1.34,1.32,1.24,1.22,1.26,1.28,0.71,0.14,0.21,0.2,0.18,0.2,0.28,0.32,0.31,0.3,0.28,0.24,0.2,0.2,0.22,0.43,0.63,0.63,0.64,1.03,1.43,1.84,2.25,2.25,2.29,2.57,2.84,3.62,4.4,3.64,2.87,3.38,3.88,3.3,2.29,1.29,1.36,1.38,1.34,1.3:1
2.08,1.85,1.61,1.47,1.0,0.54,0.44,0.34,0.34,0.35,0.31,0.24,0.24,0.25,0.24,0.23,0.21,0.19,0.17,0.14,0.16,0.19,0.17,0.23,0.28,0.28,0.26,0.26,0.21,0.16,0.16,0.23,0.24,0.24,0.24,0.25,0.22,0.23,0.24,0.23,0.22,0.25,1.44,2.63,2.01,1.38,1.36,1.33,1.32,1.31,1.3,1.29,1.29,1.29,0.88,0.47,0.32,0.17,0.15,0.13,0.13,0.22,0.29,0.2,0.2,0.22,0.24,0.24,0.2,0.22,0.22,0.21,0.2,0.25,0.24,0.23,0.23,0.22,0.18,0.23,0.28,0.28,0.27,0.27,0.27,0.24,0.2,0.2,0.16,0.16,0.15,0.13,0.57,1.01,1.21,1.07,0.93,0.55,0.16,0.17,0.19,0.22,0.22,0.23,0.25,0.28,0.26,0.24,0.24,0.2,0.2,0.25,0.29,1.14,1.99,1.27,0.54,0.43,0.46,0.48,0.44,0.4,0.48,0.58,0.67,0.57,0.47,0.48,0.58,0.67,2.2,3.72,3.98,4.23,3.6,2.97,2.22,2.22,0.36,0.36,0.4,0.36,0.33,0.35:1
0.26,0.26,0.28,0.27,0.25,0.23,0.28,0.32,0.31,0.27,0.24,0.27,0.27,0.26,0.24,0.25,0.25,0.26,0.24,0.24,0.26,0.26,0.25,0.25,0.29,0.31,0.29,0.25,0.23,0.25,0.26,0.27,0.27,0.28,0.27,0.27,0.24,0.23,0.25,0.31,0.85,1.38,1.34,1.33,1.34,1.02,0.69,0.5,0.31,0.3,0.26,0.24,0.26,0.27,0.24,0.21,0.24,0.3,0.29,0.25,0.23,0.27,0.26,0.23,0.21,0.22,0.27,0.31,0.24,0.23,0.27,0.27,0.24,0.21,0.23,0.24,0.25,0.22,0.24,0.28,0.28,0.24,0.24,0.28,0.25,0.23,0.21,0.23,0.26,0.28,0.23,0.25,0.31,0.31,0.26,0.22,0.24,0.27,0.26,0.22,0.25,0.29,0.31,0.25,0.23,0.24,0.26,0.27,0.8,1.32,1.35,1.36,1.16,0.96,0.61,0.27,0.26,0.27,0.27,0.28,0.26,0.25,0.23,0.24,0.25,0.27,0.27,0.26,0.27,0.26,0.25,0.23,0.23,0.25,0.28,0.28,0.26,0.26,0.27,0.27,0.23,0.23,0.26,0.3:1
1.31,0.87,0.62,0.38,0.33,0.3,0.28,0.28,0.28,0.27,0.25,0.26,0.27,0.29,0.31,0.31,0.31,0.3,0.28,0.26,0.25,0.26,0.27,0.28,0.27,0.26,0.3,0.34,0.33,0.29,0.25,0.26,0.27,0.27,0.26,0.25,0.27,0.32,1.2,2.07,1.75,1.43,1.49,1.56,1.66,1.71,1.76,1.76,1.71,1.62,1.99,2.37,2.37,1.28,1.28,1.86,2.43,1.87,1.3,1.27,1.28,2.55,3.83,2.63,1.44,1.39,1.37,1.38,1.37,1.36,1.35,1.37,1.44,1.59,2.31,3.04,3.04,3.34,3.34,2.89,2.44,2.38,2.34,2.2,2.05,1.24,0.42,0.48,0.52,0.51,0.46,0.46,0.48,0.5,0.39,0.29,0.34,0.39,0.36,0.28,0.68,1.07,1.29,1.39,1.38,1.31,1.21,0.78,0.35,0.91,1.47,1.62,1.77,1.74,1.56,1.37,1.0,0.63,0.64,0.65,1.01,1.37,1.38,1.69,2.01,2.08,2.12,2.0,1.81,1.81,1.82,1.82,1.25,0.69,1.12,1.55,1.95,2.35,1.75,0.96,0.25,0.25,0.31,0.4:1
0.41,0.34,0.28,0.3,0.31,0.32,0.3,0.28,0.27,0.27,0.26,0.25,0.3,0.34,0.34,0.35,0.37,0.36,0.35,0.38,0.41,0.37,0.32,0.32,0.32,0.33,0.32,0.64,0.96,1.15,1.34,1.06,0.74,0.41,0.34,0.28,0.31,0.66,1.01,1.42,1.83,2.08,2.34,2.01,1.68,1.93,2.18,2.18,2.36,2.36,2.37,2.38,2.36,2.34,2.12,1.91,2.07,2.08,2.09,1.76,1.43,1.39,1.35,1.31,1.34,1.38,1.34,1.31,1.31,1.36,1.36,1.33,1.33,1.34,1.33,1.32,1.36,1.39,1.34,1.28,1.29,1.31,1.3,1.28,1.34,1.39,1.36,1.32,1.34,1.35,1.35,1.34,1.37,1.39,1.37,1.34,1.36,1.37,1.36,1.34,1.34,1.34,1.36,1.38,1.36,1.35,1.36,1.36,1.36,0.42,0.42,0.43,0.44,0.77,1.09,1.64,2.18,1.61,1.05,1.05,1.11,1.17,1.23,1.29,1.23,1.17,1.29,1.41,1.28,1.16,1.07,0.99,0.87,0.76,0.91,0.91,0.91,0.9,0.88,0.65,0.42,0.38,0.34,0.39:1
0.95,1.0,1.03,1.0,0.96,0.93,0.9,0.64,0.38,0.39,0.4,0.36,0.31,0.32,0.32,0.31,0.31,0.31,0.3,0.27,0.24,0.27,0.31,0.31,0.32,0.34,0.38,0.41,0.37,0.54,0.71,1.05,1.39,0.83,0.27,0.31,0.29,0.27,0.26,0.25,0.27,0.3,0.27,0.34,0.41,1.36,2.32,1.37,0.43,0.57,0.72,0.71,0.69,0.72,0.75,1.2,1.66,2.76,3.86,2.84,1.82,2.37,2.92,2.2,1.48,2.02,2.56,2.61,2.87,3.13,3.13,1.15,1.15,0.76,0.36,0.37,0.38,0.34,0.32,0.34,0.36,0.3,0.3,0.31,0.31,0.3,0.29,0.28,0.28,0.28,0.31,0.33,0.45,0.58,0.56,0.54,0.53,0.53,0.5,0.5,0.53,0.46,0.4,0.37,0.33,0.35,0.36,0.4,0.43,0.47,0.96,1.45,1.48,1.12,0.77,0.55,0.32,0.38,0.36,0.34,0.34,0.35,0.36,0.37,0.35,0.34,1.78,3.21,4.3,4.08,3.87,3.59,3.32,3.31,3.3,3.33,3.37,3.31,3.36,3.41,3.36,3.32,3.38,3.44:1
0.24,0.29,0.31,0.22,0.22,0.3,0.38,0.34,0.31,0.29,0.28,0.32,0.37,0.3,0.22,0.22,0.28,0.28,0.57,0.85,1.32,0.93,0.55,0.38,0.21,0.3,0.32,0.34,0.31,0.28,0.33,0.38,0.3,0.28,0.27,0.29,0.3,0.33,0.35,1.53,2.71,2.46,2.2,2.2,2.9,2.9,2.3,1.69,2.12,2.55,2.0,1.45,1.37,1.39,1.41,1.4,1.21,1.01,0.65,0.29,0.3,0.31,0.32,0.3,0.29,0.36,0.41,0.46,0.47,0.48,0.44,0.41,0.31,0.22,0.35,0.48,0.4,0.33,0.59,0.92,1.25,1.71,2.17,2.12,2.07,1.98,1.89,1.69,1.48,1.05,0.62,0.48,0.35,0.41,0.39,0.38,0.32,0.33,0.33,0.3,0.27,0.27,0.28,0.28,0.31,0.28,0.28,0.54,0.8,0.8,1.23,1.23,0.88,0.52,0.6,1.09,1.58,2.14,1.43,0.72,0.63,0.53,0.49,0.44,0.47,0.49,1.2,1.91,1.91,3.33,3.33,2.83,2.83,0.58,0.58,0.53,0.46,0.39,0.41,0.43,0.36,0.3,0.3,0.3:1
2.68,2.65,2.6,2.52,2.2,1.88,1.74,1.6,1.6,0.28,0.28,0.3,0.36,0.45,1.46,2.47,1.39,0.31,0.31,0.28,0.26,0.25,0.3,0.37,0.43,0.48,0.53,0.54,0.56,0.54,0.52,0.49,0.49,0.5,0.5,0.46,0.41,0.42,0.48,0.45,0.43,0.4,0.42,0.48,0.44,0.41,0.41,0.46,0.53,0.56,0.5,0.46,0.49,0.52,0.54,0.49,0.44,0.44,1.77,1.77,1.24,0.71,1.1,1.49,1.42,1.35,1.3,1.26,1.27,1.3,1.33,1.36,0.98,0.6,0.47,0.34,0.29,0.25,0.26,0.33,0.27,0.22,0.17,0.16,0.26,0.36,0.32,0.29,0.3,0.34,0.37,0.33,0.3,0.32,0.4,0.4,0.41,0.31,0.25,0.31,0.3,0.3,0.31,0.33,0.36,0.36,0.27,0.17,0.68,1.19,1.0,0.82,1.17,1.51,1.0,0.53,0.43,0.46,0.49,0.55,0.57,0.59,0.54,0.5,0.5,0.51,0.51,0.63,0.74,1.07,1.4,1.49,1.34,0.99,0.67,0.93,1.12,1.31,1.24,0.7,0.16,0.22,0.25,0.27:1
0.35,0.33,0.32,0.31,0.31,1.29,1.29,0.9,0.52,0.4,0.28,0.25,0.22,0.25,0.29,0.34,0.39,0.39,0.22,0.22,0.23,0.24,0.25,0.27,0.23,0.19,0.19,0.22,0.22,0.2,0.19,0.19,0.19,0.19,0.17,0.14,0.13,0.16,0.19,0.19,0.18,0.21,0.25,0.26,0.26,0.25,0.24,0.21,0.2,0.18,0.19,0.19,0.19,0.19,0.19,1.4,2.61,1.99,1.37,0.77,0.18,0.21,0.25,0.69,1.13,1.35,1.71,2.07,2.08,2.08,2.75,3.41,2.6,1.78,1.66,2.67,3.68,2.6,1.53,2.1,2.2,1.5,0.81,0.74,2.32,3.9,3.9,3.95,3.95,2.69,1.43,0.97,0.51,1.54,2.58,1.46,0.34,0.36,0.38,0.34,0.3,0.34,0.36,0.37,0.38,0.39,0.37,0.35,0.42,0.5,0.38,0.26,0.48,0.69,0.7,0.71,0.65,0.59,0.76,0.93,0.84,0.76,1.04,1.51,1.98,2.48,2.98,2.67,2.37,2.0,1.64,1.39,1.13,0.73,0.57,0.42,0.42,0.3,0.24,0.24,0.29,0.34,0.34,0.34:1
0.19,0.2,0.2,0.2,0.22,0.26,0.29,0.28,0.25,0.23,0.21,0.16,0.13,0.17,0.21,0.17,0.17,0.22,0.28,0.2,0.18,0.2,0.2,0.17,0.19,0.21,0.2,0.16,0.75,1.33,0.92,0.52,0.34,0.17,0.18,0.2,0.19,0.18,0.21,0.26,0.25,0.14,0.51,0.88,1.07,1.27,1.66,2.05,1.74,1.74,2.31,2.31,1.78,1.25,1.3,1.31,1.29,2.37,3.45,2.31,1.16,0.73,0.29,0.2,0.17,0.2,0.18,0.15,0.14,0.16,0.18,0.18,0.23,0.2,0.18,0.15,0.16,0.16,0.16,0.15,0.18,0.21,0.21,0.23,0.23,0.22,0.18,0.18,0.17,0.18,0.18,0.21,0.26,0.27,0.27,0.26,0.21,0.2,0.19,0.21,0.18,0.18,0.19,0.22,0.21,0.23,0.25,0.24,0.16,0.16,0.21,0.26,0.71,1.17,1.56,1.55,1.54,1.42,1.31,1.25,1.25,1.21,1.17,0.91,0.65,0.54,0.42,0.33,0.38,0.42,0.39,0.32,0.25,0.23,0.2,0.16,0.12,0.21,0.31,0.21,0.19,0.2,0.19,0.12:1
0.23,0.25,0.25,0.23,0.21,0.19,0.18,0.2,0.21,0.23,0.24,0.24,0.23,0.2,0.19,0.18,0.19,0.21,0.23,0.24,0.23,0.22,0.21,0.19,0.18,0.19,0.22,0.23,0.24,0.23,0.22,0.21,0.2,0.19,0.19,0.21,0.23,0.24,0.22,0.21,0.22,0.53,0.69,0.55,0.26,0.65,1.05,1.2,1.35,1.29,1.24,1.21,1.21,1.26,0.96,0.66,0.42,0.18,0.21,0.21,0.17,0.16,0.19,0.24,0.25,0.23,0.23,0.25,0.25,0.23,0.23,0.23,0.26,0.3,0.34,0.89,1.44,0.88,0.32,0.22,0.23,0.26,0.3,0.29,0.23,0.33,0.42,0.37,0.31,0.28,0.31,0.36,0.42,0.37,0.37,0.37,0.34,0.31,0.27,0.35,0.43,0.45,0.45,1.43,1.43,1.52,1.61,1.38,1.34,1.3,1.38,0.98,0.58,0.37,0.17,0.24,0.32,0.24,0.23,0.28,1.58,2.88,1.95,1.02,0.96,0.88,1.61,2.33,3.47,4.6,2.94,2.12,1.3,1.2,1.1,1.29,1.48,3.2,2.3,1.4,1.33,1.28,0.91,0.54:1
0.27,0.34,0.41,0.38,0.35,0.39,0.35,0.31,0.32,0.33,0.33,0.35,0.38,0.3,0.32,0.33,0.29,0.25,0.29,0.35,0.32,0.3,0.29,0.28,0.31,0.34,0.33,0.32,0.3,0.29,0.29,0.29,0.29,0.29,0.31,0.33,0.28,0.22,0.27,0.32,0.3,1.14,1.99,1.36,0.74,1.29,1.69,2.09,1.88,1.67,1.48,1.29,1.09,0.89,0.59,0.29,0.3,0.32,0.31,0.3,0.25,0.33,0.4,0.36,0.32,0.35,0.37,0.37,0.38,0.38,0.38,0.4,0.42,0.41,0.4,0.4,0.39,0.44,0.42,0.4,0.4,0.4,0.49,0.49,0.49,0.64,0.79,0.53,0.26,0.27,0.29,0.31,0.34,0.35,0.36,0.35,0.34,0.27,0.27,0.28,0.33,0.31,0.29,0.28,0.27,0.82,1.36,1.28,1.12,0.96,0.64,0.32,0.45,0.58,0.97,1.37,2.12,2.12,0.73,0.73,0.8,1.29,1.77,2.0,2.23,2.61,2.98,2.89,2.8,2.62,2.44,2.3,2.16,2.01,1.85,1.61,1.36,1.41,1.42,1.44,1.41,1.38,0.86,0.35:1
0.23,0.26,0.74,1.22,1.56,1.89,1.78,1.67,1.48,1.28,1.2,1.16,1.21,0.89,0.57,0.35,0.13,0.18,0.21,0.2,0.18,0.18,0.18,0.17,0.18,0.21,0.2,0.16,0.16,0.19,0.23,0.2,0.16,0.15,0.2,0.21,0.18,0.16,0.18,0.19,0.19,0.21,0.26,1.04,1.83,1.79,1.59,1.39,1.32,1.29,1.28,2.15,3.02,2.64,2.27,2.25,2.23,2.19,2.17,2.11,1.99,2.15,2.3,1.8,1.29,1.3,1.32,1.33,1.3,1.26,1.67,2.08,1.64,1.2,1.24,1.27,1.25,1.21,1.2,1.21,1.22,0.69,0.15,0.23,0.24,0.23,0.24,0.27,0.26,0.2,0.17,0.23,0.24,0.22,0.21,0.22,0.21,0.21,0.23,0.25,0.22,0.18,0.2,0.25,0.26,0.21,0.18,0.23,0.24,0.22,0.2,0.21,0.21,0.22,0.23,0.22,0.19,0.21,0.25,0.25,0.2,0.17,0.21,0.23,0.23,0.22,0.2,0.23,0.22,0.21,0.21,0.21,0.2,0.21,0.24,0.22,0.18,0.17,0.21,0.25,1.17,2.1,2.1,2.1:1
0.34,0.34,0.34,0.26,0.18,0.83,1.48,1.36,0.95,0.55,0.42,0.29,0.26,0.24,0.24,0.25,0.23,0.25,0.26,0.25,0.25,0.26,0.28,0.3,0.33,0.31,0.3,0.27,0.25,0.22,0.2,0.22,0.24,0.22,0.19,0.22,0.24,0.24,0.25,1.79,3.33,2.94,2.54,2.54,1.58,1.58,1.46,1.34,1.61,1.79,1.96,1.97,1.63,1.29,1.31,1.34,1.32,1.3,1.28,1.26,1.24,1.21,0.92,0.64,0.45,0.26,0.23,0.24,0.26,0.25,0.25,0.29,0.34,0.33,0.33,0.31,0.29,0.32,0.35,0.31,0.27,0.23,0.2,1.29,2.39,0.77,0.75,0.74,1.08,1.42,1.37,1.58,1.79,1.04,0.29,0.35,0.32,0.28,0.3,0.32,0.19,0.17,0.16,0.24,0.32,0.32,0.32,0.32,0.28,0.28,0.26,0.25,0.26,0.27,0.24,0.21,0.21,0.21,0.23,0.24,0.93,1.62,2.12,2.63,2.63,1.18,1.18,1.01,0.83,0.78,0.74,0.72,0.71,0.7,0.84,0.97,1.23,1.49,1.17,0.85,0.83,0.79,0.75,0.73:1
0.49,0.44,0.38,0.4,0.41,0.38,0.35,0.35,0.35,0.35,0.4,0.43,0.42,0.39,0.39,0.36,0.33,0.34,0.35,0.36,0.38,0.38,0.38,0.38,0.41,0.41,0.38,0.36,0.36,0.36,0.38,0.4,0.41,0.43,0.41,0.38,0.36,0.34,0.33,0.32,1.79,3.26,2.38,1.5,1.49,1.55,1.61,1.53,1.45,1.36,1.28,1.33,1.44,1.55,1.66,1.65,1.65,1.62,1.58,1.4,1.21,1.23,1.25,1.25,1.24,1.24,1.25,1.25,1.24,1.23,1.23,1.23,1.1,0.98,0.62,0.26,0.24,0.22,0.2,0.19,0.17,0.14,0.19,0.23,0.22,0.22,0.22,0.21,0.2,0.19,0.18,0.18,0.17,0.19,0.21,0.23,0.26,0.25,0.25,0.4,0.55,0.51,0.47,0.37,0.27,0.26,0.26,0.25,0.26,0.27,0.26,0.25,0.43,0.83,1.22,1.79,2.37,2.12,1.88,1.86,1.94,2.01,2.2,2.39,2.91,3.42,2.83,2.23,1.95,1.66,1.63,2.71,3.78,2.18,0.58,0.57,0.56,0.73,0.91,0.96,1.0,1.07,0.98,0.89:1
0.46,0.47,0.46,0.43,0.41,0.41,0.44,0.43,0.42,0.46,0.49,0.48,0.44,0.57,0.69,1.11,1.53,1.33,1.14,0.81,0.48,0.44,0.43,0.46,0.47,0.48,0.47,0.48,0.47,0.46,0.42,0.43,0.47,0.5,0.47,0.46,0.48,0.46,0.43,0.42,0.46,0.45,0.45,0.46,1.53,2.59,1.91,1.23,1.62,2.02,2.63,2.63,3.13,3.13,2.96,2.79,2.73,3.24,3.74,3.99,4.24,4.84,5.43,4.56,3.69,3.11,2.52,3.35,4.19,4.21,4.21,3.51,2.81,2.27,1.72,2.27,2.83,2.34,1.84,1.74,2.24,2.74,2.82,2.58,2.34,1.74,1.74,1.43,1.43,1.35,1.33,1.34,1.34,1.33,1.35,1.37,0.79,0.21,0.23,0.28,0.28,0.27,0.27,0.29,0.27,0.24,0.23,0.26,0.29,0.29,0.27,0.26,0.27,0.24,0.22,0.24,0.27,0.31,0.31,0.25,0.24,0.28,0.28,0.24,0.26,0.35,0.28,0.2,0.22,0.24,0.23,0.22,0.22,0.26,0.26,0.26,0.23,0.25,0.28,0.28,0.26,0.27,0.31,0.32:1
0.28,0.27,0.26,0.29,0.33,0.26,0.22,0.21,0.25,0.29,0.26,0.27,0.29,0.31,0.27,0.23,0.22,0.26,0.28,0.27,0.26,0.24,0.23,0.26,0.26,0.25,0.24,0.25,0.27,0.31,0.33,0.29,0.25,0.26,0.25,0.25,0.26,0.28,0.31,0.33,0.97,1.61,1.83,2.04,1.48,0.92,1.49,2.06,1.67,1.27,1.29,1.31,1.3,1.29,1.25,1.28,1.35,1.33,1.31,1.29,1.27,1.3,1.32,1.26,1.23,1.29,1.32,1.34,1.1,0.86,0.58,0.3,0.26,0.21,0.26,0.32,0.31,0.29,0.37,0.45,0.37,0.31,0.27,0.26,0.25,0.26,0.26,0.23,0.24,0.25,0.25,0.24,0.24,0.29,0.35,0.42,0.49,0.36,0.24,0.24,0.23,0.22,0.22,0.43,0.64,0.56,0.48,0.49,0.38,0.26,0.23,0.2,0.32,0.45,0.58,0.81,1.04,0.93,0.83,0.99,1.16,1.85,2.55,2.27,3.16,4.06,3.03,2.0,1.85,1.69,1.61,1.75,1.89,2.45,2.13,1.82,1.84,1.85,1.69,1.54,1.26,0.98,1.09,1.21:1
0.24,0.24,0.26,0.3,0.27,0.23,0.2,0.23,0.26,0.29,0.19,0.13,0.14,0.18,0.22,0.15,0.12,0.16,0.18,0.21,0.15,0.14,0.17,0.19,0.22,0.24,0.24,0.23,0.24,0.25,0.26,0.24,0.22,0.21,0.23,0.23,0.18,0.14,0.11,0.51,0.91,1.09,1.28,1.35,1.42,1.44,1.44,1.36,1.29,0.79,0.29,0.25,0.23,0.23,0.24,0.25,0.26,0.22,0.18,0.15,0.19,0.21,0.17,0.13,0.15,0.21,0.19,0.16,0.13,0.15,0.21,0.22,0.23,0.2,0.22,0.27,0.25,0.22,0.19,0.21,0.27,0.22,0.16,0.13,0.14,0.19,0.18,0.17,0.13,0.14,0.19,0.19,0.2,0.14,0.17,0.24,0.26,0.27,0.19,0.76,1.34,1.38,0.78,0.19,0.22,0.24,0.23,0.2,0.18,0.17,0.2,0.25,0.21,0.16,0.11,1.33,2.55,1.48,0.41,0.41,0.42,1.53,2.63,2.31,1.99,1.96,1.9,1.84,2.06,2.3,2.55,5.22,4.21,3.19,2.96,2.87,2.78,3.41,4.04,1.75,1.02,0.29,0.28,0.29:1
0.44,0.33,0.23,0.18,0.19,0.23,0.26,0.25,0.24,0.22,0.21,0.2,0.19,0.15,0.7,1.26,1.2,0.79,0.38,0.25,0.18,0.19,0.22,0.2,0.18,0.2,0.21,0.2,0.21,0.19,0.19,0.22,0.22,0.17,0.18,0.22,0.21,0.18,0.19,0.21,0.21,0.69,1.17,0.8,0.43,0.66,0.88,1.11,1.33,1.22,1.12,0.88,0.64,0.39,0.15,0.18,0.19,0.19,0.2,0.17,0.17,0.2,0.2,0.16,0.17,0.2,0.2,0.18,0.18,0.19,0.19,0.2,0.18,0.17,0.19,0.2,0.17,0.16,0.2,0.21,0.18,0.17,0.19,0.19,0.19,0.19,0.17,0.18,0.2,0.19,0.16,0.19,0.2,0.18,0.17,0.18,0.19,0.19,0.19,0.17,0.18,0.21,0.21,0.16,0.16,0.53,0.88,1.16,1.28,0.89,0.5,0.35,0.21,0.17,0.19,0.2,0.19,0.16,0.2,0.21,0.19,0.18,0.19,0.19,0.19,0.2,0.18,0.18,0.21,0.21,0.17,0.17,0.21,0.2,0.18,0.18,0.48,0.67,0.61,0.32,0.24,0.18,0.2,0.18:1
0.17,0.16,0.18,0.16,0.14,0.14,0.17,0.16,0.15,0.14,0.16,0.2,0.24,0.22,0.22,0.23,0.25,0.18,0.13,0.16,0.19,0.15,0.14,0.17,0.2,0.15,0.16,0.2,0.22,0.21,0.23,0.27,0.25,0.19,0.17,0.19,0.2,0.42,0.79,1.24,0.98,0.72,0.49,0.26,0.27,0.26,0.88,1.5,1.82,2.14,1.78,1.42,1.32,1.25,1.22,1.24,1.27,1.26,1.25,1.26,1.28,1.28,1.32,1.37,1.02,0.68,0.62,0.56,0.55,0.54,0.73,0.93,0.63,0.32,0.33,0.33,0.35,0.4,0.46,0.4,0.35,0.59,0.83,1.85,2.14,2.44,1.98,1.53,2.02,2.51,2.51,1.38,1.38,1.36,1.34,1.33,1.32,1.32,1.35,1.34,1.33,0.91,0.51,0.35,0.3,0.29,0.32,0.37,0.4,0.4,0.4,0.4,0.39,0.36,0.51,0.66,0.79,0.91,1.27,1.62,1.77,1.77,0.87,0.87,0.68,1.57,2.46,2.5,2.85,3.21,2.93,2.66,1.51,0.36,0.38,0.37,0.34,0.33,0.32,0.28,0.25,0.24,0.26,0.25:1
0.18,0.18,0.17,0.2,0.22,0.23,0.2,0.22,0.24,0.28,0.31,0.41,0.34,0.26,0.26,0.35,0.35,0.28,0.21,0.19,0.22,0.25,0.26,0.44,0.61,0.96,1.31,1.34,0.78,0.21,0.19,0.17,0.19,0.21,0.25,0.24,0.23,0.22,0.27,0.33,0.29,0.25,0.21,0.24,0.27,0.29,0.3,0.24,0.22,0.2,0.22,0.25,0.23,0.21,0.18,0.17,0.17,0.24,0.2,0.16,0.14,0.17,0.2,0.25,0.31,0.26,0.21,0.25,0.28,0.3,0.29,0.28,0.28,0.28,0.28,0.33,0.38,0.26,0.14,0.2,0.25,0.22,0.19,0.16,0.14,0.22,0.29,0.42,0.54,0.51,0.52,0.53,1.17,1.81,1.81,1.8,1.79,1.77,1.3,0.83,0.77,0.7,0.97,1.24,1.37,1.5,1.4,1.31,1.03,0.76,0.62,0.49,0.42,0.43,0.44,0.43,0.43,0.41,0.39,0.37,0.4,0.42,0.51,0.47,0.42,0.4,0.39,0.86,1.32,0.86,0.4,0.54,0.69,1.02,0.98,0.94,0.49,0.64,0.8,1.04,1.29,0.94,0.58,0.32:1
0.4,0.36,0.33,0.35,0.58,0.81,1.35,1.15,0.95,0.61,0.27,0.29,0.31,0.33,0.34,0.34,0.35,0.32,0.28,0.28,0.29,0.29,0.31,0.31,0.24,0.24,0.27,0.31,0.31,0.38,0.38,0.33,0.27,0.28,0.29,0.29,0.29,0.3,0.31,0.75,1.2,1.75,2.31,1.45,0.6,1.15,1.71,2.01,2.31,2.43,2.54,1.92,1.31,0.88,0.44,0.37,0.29,0.89,1.49,0.92,0.35,0.31,0.59,0.86,0.88,0.87,0.86,0.82,0.78,0.71,0.65,0.54,0.51,0.47,0.56,0.65,0.56,0.48,0.48,0.78,0.78,0.93,1.09,1.08,0.93,0.77,0.93,1.08,1.31,1.54,1.6,1.72,1.83,1.77,1.71,1.28,0.84,0.84,0.83,0.6,0.6,0.46,0.33,0.45,0.57,0.6,0.63,0.61,0.59,0.59,0.59,0.59,0.7,0.82,0.81,0.8,0.59,0.37,0.43,0.98,1.52,1.98,1.77,1.56,2.12,2.67,2.8,2.94,2.89,2.84,2.41,1.98,1.63,1.33,1.02,0.66,0.31,0.3,0.3,0.27,0.24,0.28,0.33,0.28:1
0.37,0.37,0.36,0.37,0.38,0.29,0.22,0.3,0.29,0.28,0.23,0.27,0.36,0.34,0.33,0.28,0.28,0.3,0.31,0.26,0.25,0.28,0.32,0.33,0.33,0.32,0.31,0.31,0.29,0.28,0.27,0.3,0.3,0.31,0.31,0.32,0.32,0.33,1.68,3.03,2.23,1.44,1.48,1.52,1.55,1.59,1.64,2.71,3.78,2.68,1.58,2.19,2.8,2.12,1.45,1.48,1.55,1.44,1.33,1.3,1.28,1.27,1.27,1.27,1.27,1.27,1.75,1.75,1.71,1.63,1.56,1.53,1.47,1.24,1.01,0.98,0.94,0.79,0.63,0.55,0.47,1.04,1.61,2.03,2.44,2.32,2.19,2.11,2.03,1.87,1.63,1.39,1.12,0.67,0.22,0.28,0.33,0.35,0.32,0.31,0.34,0.36,0.33,0.26,0.22,0.26,0.29,0.32,0.31,0.3,0.41,0.6,0.85,1.23,1.62,1.46,1.09,0.72,0.69,0.65,0.94,1.22,1.21,1.21,1.21,0.95,1.2,1.45,1.92,2.39,2.23,2.05,1.68,1.32,1.09,0.91,1.23,1.54,1.71,1.76,1.81,1.05,0.29,0.29:1
1.98,2.13,2.28,1.97,1.8,1.68,1.66,1.63,1.57,1.45,1.35,1.26,1.23,1.2,0.89,0.58,0.4,0.22,0.22,0.19,0.2,0.23,0.22,0.19,0.17,0.22,0.18,0.15,0.17,0.21,0.22,0.2,0.19,0.2,0.21,0.2,0.21,0.2,0.19,0.19,0.22,0.21,0.14,0.2,0.26,0.2,0.15,0.14,0.2,0.25,0.32,0.39,0.65,0.91,1.16,1.4,1.44,1.38,1.32,1.35,1.35,3.72,3.72,3.72,2.37,2.37,2.59,2.56,2.53,2.31,2.32,2.34,1.79,1.25,1.27,1.29,1.31,1.26,1.25,1.25,1.25,1.22,1.22,1.23,1.24,1.24,1.25,1.24,1.24,1.24,1.27,1.26,1.24,1.24,0.96,0.67,0.41,0.14,0.16,0.19,0.15,0.17,0.2,0.2,0.19,0.18,0.19,0.18,0.17,0.18,0.18,0.17,0.18,0.2,0.17,0.16,0.18,0.17,0.17,0.14,0.14,0.16,0.18,0.15,0.17,0.2,0.19,0.18,0.17,0.18,0.17,0.17,0.18,0.18,0.18,0.19,0.2,0.17,0.15,0.16,0.16,2.13,2.13,2.3:1
0.35,0.35,0.35,0.35,0.39,0.39,0.35,0.32,0.34,0.35,0.37,0.36,0.35,0.35,0.38,0.38,0.34,0.29,0.29,0.3,0.32,0.35,0.32,0.34,0.36,0.31,0.26,0.26,0.26,0.32,0.38,0.31,0.24,0.24,0.3,0.3,0.32,0.34,0.34,0.34,1.54,2.74,2.21,1.69,1.71,1.73,1.31,0.89,1.54,2.2,1.95,1.7,1.79,1.8,1.82,1.54,1.44,1.35,1.44,1.39,1.33,1.33,1.34,1.34,1.34,1.13,0.77,0.42,0.42,0.36,0.36,0.94,1.51,1.81,1.81,1.49,1.49,1.4,0.93,0.46,0.46,0.33,0.3,0.47,0.47,0.55,0.63,0.49,0.36,0.33,0.32,0.31,0.28,0.32,0.36,0.33,0.33,0.32,0.31,0.3,0.3,0.37,0.37,0.59,0.82,1.09,1.36,1.02,0.68,0.33,0.35,0.37,0.35,0.32,0.63,0.94,1.57,2.19,2.31,2.42,2.33,2.23,2.11,1.99,2.4,2.7,3.01,3.79,4.57,3.71,2.85,2.91,2.97,2.62,2.28,2.76,3.25,2.31,1.38,1.4,1.42,1.41,1.4,1.31:1
0.1,0.2,0.16,0.12,0.14,0.18,0.19,0.17,0.16,0.17,0.18,0.17,0.18,0.19,0.2,0.23,0.23,0.2,0.19,0.2,0.19,0.15,0.15,0.22,0.63,1.03,1.28,1.54,1.49,1.0,0.52,0.49,0.48,0.49,0.9,1.32,1.18,0.86,0.47,0.19,0.17,0.17,0.17,0.16,0.17,0.18,0.16,0.12,0.08,0.04,0.39,0.88,1.34,1.72,2.09,2.37,2.66,2.08,1.51,1.52,1.54,1.47,1.4,1.5,1.55,1.58,1.61,1.62,1.56,1.42,1.28,1.27,1.27,1.27,1.27,1.24,1.22,1.2,1.16,1.16,1.19,1.21,1.18,1.27,1.35,1.47,1.43,1.39,2.4,3.41,2.35,1.29,1.3,1.27,1.22,1.77,2.32,1.73,1.13,1.18,1.17,1.13,0.82,0.48,0.22,0.17,0.15,0.19,0.21,0.19,0.17,0.18,0.18,0.19,0.2,0.19,0.16,0.17,0.21,0.21,0.14,0.17,0.22,0.22,0.17,0.15,0.2,0.2,0.18,0.16,0.18,0.19,0.18,0.18,0.17,0.17,0.18,0.19,0.18,0.17,0.18,0.2,0.17,0.1:1
0.91,0.87,0.84,0.82,0.9,0.98,0.78,0.58,0.6,0.62,0.51,0.4,0.4,0.41,0.39,0.35,0.32,0.29,0.26,0.41,0.55,0.52,0.49,0.51,0.52,0.52,0.45,0.52,0.58,0.57,0.57,0.39,0.21,0.45,0.7,0.93,1.17,0.78,0.52,0.25,0.21,0.2,0.19,0.29,0.28,0.27,0.26,0.24,0.23,0.21,0.19,0.56,0.93,0.74,0.55,0.43,0.87,1.31,1.34,1.37,1.34,1.32,1.2,1.07,0.62,0.17,0.54,0.95,1.35,1.46,1.46,5.79,5.79,5.07,4.35,4.41,4.47,3.45,2.43,2.04,1.64,1.68,1.73,1.77,1.77,1.77,2.2,2.62,2.06,1.9,1.73,1.51,2.12,2.73,2.05,1.37,1.05,0.73,0.55,0.37,0.37,0.37,0.5,0.62,0.67,0.72,0.96,1.19,1.0,0.81,0.83,0.84,0.71,0.57,0.58,0.75,0.92,0.99,1.07,1.19,1.51,1.82,1.82,1.77,1.72,1.69,1.66,2.1,2.55,2.08,1.6,1.6,2.52,2.52,2.0,1.48,1.6,1.77,1.93,1.58,1.22,1.22,1.11,1.11:1
0.34,0.28,0.24,0.25,0.28,0.29,0.25,0.25,0.29,0.33,0.34,0.28,0.27,0.27,0.28,0.26,0.26,0.28,0.27,0.22,0.58,0.95,1.15,1.34,1.19,1.04,0.67,0.29,0.25,0.25,0.29,0.28,0.25,0.24,0.27,0.29,0.28,0.26,0.3,0.37,0.34,0.27,0.22,0.22,0.24,0.27,0.23,0.23,0.27,0.25,0.22,0.22,0.22,0.31,0.41,0.3,0.25,0.27,0.29,0.27,0.23,0.25,0.27,0.29,0.26,0.25,0.27,0.31,0.33,0.33,0.32,0.3,0.27,0.25,0.25,0.27,0.26,0.25,0.24,0.27,0.29,0.27,0.22,0.45,0.68,0.99,1.3,1.29,1.28,0.85,0.47,0.23,0.23,0.27,0.25,0.23,0.22,0.29,0.38,0.33,0.28,0.25,0.26,0.29,0.28,0.24,0.24,0.26,0.28,0.26,0.25,0.26,0.29,0.32,0.32,0.31,0.29,0.27,0.25,0.24,0.27,0.27,0.26,0.24,0.26,0.29,0.28,0.28,0.29,0.36,0.3,0.25,0.22,0.25,0.29,0.3,0.25,0.22,0.22,0.26,0.29,0.24,0.27,0.34:1
0.19,0.24,0.3,0.29,0.29,0.32,0.34,0.29,0.26,0.22,0.27,0.25,0.23,0.22,0.22,0.22,0.16,0.16,0.16,0.16,0.25,0.26,0.27,0.27,0.2,0.2,0.2,0.21,0.21,0.22,0.23,0.22,0.22,0.24,0.26,0.22,0.22,0.22,0.23,0.23,0.9,1.56,1.02,0.49,0.77,1.05,1.29,1.52,2.98,2.1,1.22,1.67,2.11,1.68,1.26,1.22,1.19,0.71,0.24,0.26,0.29,0.28,0.28,0.3,0.25,0.2,0.2,0.19,0.21,0.13,0.13,0.15,0.18,0.22,0.26,0.32,0.3,0.29,0.28,0.27,0.24,0.22,0.15,0.17,0.19,0.2,0.22,0.22,0.22,0.22,0.21,0.2,0.21,0.23,0.25,0.25,0.26,0.24,0.24,0.24,0.23,0.22,0.21,0.2,0.17,0.14,0.18,0.19,0.2,0.46,0.72,1.13,1.55,1.13,0.71,0.65,0.6,0.53,0.47,0.45,0.43,0.43,1.03,1.63,1.0,0.38,0.38,0.36,0.36,0.36,2.0,2.0,2.23,1.87,1.5,1.06,0.61,0.61,0.27,0.27,0.27,0.27,0.27,0.27:1
0.32,0.35,0.31,0.31,0.33,0.35,0.3,0.25,0.26,0.26,0.28,0.3,0.28,0.26,0.29,0.32,0.28,0.24,0.3,0.36,0.33,0.31,0.29,0.27,0.28,0.28,0.28,0.28,0.28,0.27,0.26,0.29,0.29,0.29,0.3,0.34,0.37,0.64,0.91,0.91,3.02,3.02,2.64,2.26,2.44,2.78,3.13,3.05,3.55,4.04,3.16,2.28,2.02,1.72,1.42,1.86,2.3,1.82,1.35,1.33,1.31,1.31,1.37,1.37,1.3,1.39,1.48,1.68,1.66,1.64,1.64,2.06,2.48,2.75,3.03,3.03,3.67,3.67,2.88,2.62,2.37,2.36,2.34,2.4,2.46,2.44,2.41,2.42,2.42,2.45,3.62,4.79,4.53,4.28,4.21,3.84,3.48,3.08,2.68,2.6,1.6,0.61,0.61,0.53,0.53,1.09,1.65,1.79,1.94,2.08,2.36,2.53,2.71,2.79,2.86,2.77,2.68,2.68,0.91,0.91,0.81,0.7,0.78,2.24,3.7,3.55,3.6,3.66,3.32,2.98,2.82,2.65,2.65,3.49,3.49,1.96,0.43,0.43,0.38,0.37,0.37,0.35,0.32,0.32:2
0.33,0.87,1.4,0.99,0.58,0.46,0.34,0.26,0.28,0.31,0.31,0.32,0.32,0.32,0.32,0.27,0.22,0.23,0.26,0.27,0.29,0.28,0.26,0.32,0.38,0.28,0.28,0.26,0.26,0.27,0.28,0.29,0.29,0.28,0.28,0.28,0.29,0.31,0.3,0.31,0.32,0.3,0.28,1.16,2.04,1.91,1.59,1.26,1.02,0.78,2.42,4.07,3.52,2.97,2.97,0.71,0.71,0.41,2.14,3.88,3.39,2.91,2.53,2.53,5.27,5.27,4.84,4.41,3.54,2.68,2.17,1.74,1.31,1.02,1.49,1.97,2.64,3.32,2.86,2.41,2.01,1.62,1.14,0.66,1.58,2.51,2.11,1.7,1.13,1.13,2.05,2.05,1.93,1.8,1.8,1.81,1.76,1.73,1.74,1.75,2.19,2.63,2.58,2.82,3.07,2.85,2.64,2.45,2.27,2.07,1.87,1.71,1.87,2.03,2.39,2.96,3.52,3.3,3.08,2.93,3.86,4.78,4.9,5.02,4.92,4.83,5.02,5.21,4.78,4.34,4.68,5.02,5.39,5.76,5.66,5.55,5.75,5.95,5.4,4.86,4.86,4.78,4.78,5.53:2
0.42,0.48,0.45,0.42,0.51,0.6,0.88,1.16,1.32,1.49,1.35,1.21,0.81,0.4,0.45,0.51,0.51,0.46,0.46,0.46,0.45,0.44,0.44,0.44,0.46,0.46,0.48,0.45,0.42,0.42,0.42,0.45,0.45,0.45,0.47,0.47,0.5,0.52,1.1,1.68,2.14,2.6,2.48,2.21,1.93,2.12,2.3,2.45,2.6,2.24,2.19,2.14,2.23,2.14,2.06,1.99,1.91,1.98,2.05,2.03,2.01,1.82,1.64,1.64,1.57,1.57,1.56,1.56,1.56,1.61,1.61,1.56,1.5,1.45,1.39,1.39,4.85,4.85,4.19,3.52,5.22,6.93,6.32,5.01,3.7,2.79,2.79,3.68,3.68,3.34,3.2,3.06,3.09,2.68,2.27,1.87,1.47,1.41,1.42,1.44,1.5,1.26,1.01,0.68,0.35,0.52,0.7,0.85,1.0,1.7,2.4,3.05,3.71,2.89,2.08,1.8,1.53,1.84,2.19,2.54,2.65,2.76,2.31,1.85,1.68,1.49,1.3,1.09,0.87,0.91,0.92,0.93,0.93,0.77,0.77,0.69,0.61,0.62,0.62,0.38,0.32,0.26,0.26,0.26:2
0.33,0.3,0.32,0.43,0.49,0.55,0.57,0.44,0.3,0.27,0.3,0.35,0.39,0.36,0.37,0.4,0.4,0.36,0.31,0.32,0.31,0.3,0.32,0.3,0.3,0.31,0.32,0.3,0.25,0.56,0.86,1.09,1.32,1.21,1.11,0.72,0.33,0.65,0.98,1.57,3.09,4.61,3.43,2.25,2.26,2.27,2.06,1.85,1.82,1.6,1.39,1.36,1.37,1.41,1.43,1.42,1.41,1.44,1.46,1.37,1.35,1.39,1.39,1.35,1.35,1.39,1.4,1.36,1.36,1.37,1.39,1.38,1.39,1.38,1.4,1.43,1.47,1.48,1.45,1.41,1.42,1.47,0.86,0.26,0.28,0.29,0.31,0.29,0.31,0.35,0.34,0.31,0.31,0.32,0.32,0.33,0.38,0.44,0.45,0.47,0.51,0.54,0.49,0.51,0.53,0.5,0.38,0.26,0.37,0.49,0.85,1.22,2.38,3.54,3.12,2.71,2.71,5.53,5.53,4.88,4.58,4.28,3.86,3.49,3.12,3.02,2.94,2.9,2.95,2.99,2.94,2.89,2.86,2.81,2.62,2.36,2.04,1.89,1.75,1.7,1.67,1.65,1.63,1.63:2
0.29,0.29,0.29,0.3,0.3,0.31,0.31,0.31,0.31,0.29,0.28,0.26,0.25,0.26,0.27,0.25,0.24,0.26,0.29,0.3,0.3,0.3,0.29,0.27,0.26,0.28,0.31,0.29,0.27,0.23,0.23,1.45,1.45,1.35,0.92,0.49,0.36,0.24,0.28,0.31,0.38,0.72,1.06,0.95,0.84,1.24,1.64,1.85,2.06,1.7,1.35,1.36,1.51,1.66,1.73,1.79,1.82,1.85,1.85,1.85,1.86,1.63,1.41,1.4,1.39,1.33,1.4,1.47,1.47,1.46,1.42,1.38,1.98,2.59,1.97,1.35,1.33,1.32,1.32,1.84,1.84,1.71,1.58,1.64,1.7,1.66,1.51,1.37,1.38,1.39,1.43,1.5,1.49,1.48,1.45,1.46,1.46,1.75,2.04,1.91,1.78,1.57,1.36,1.46,1.56,1.7,1.83,1.95,2.06,2.04,2.01,2.36,2.7,2.96,3.23,3.39,3.54,2.78,2.03,2.38,2.74,2.86,2.97,3.4,3.83,2.77,2.07,1.37,1.43,1.49,1.41,1.71,2.01,1.28,0.54,0.7,0.85,0.86,0.87,1.09,1.31,1.44,1.56,1.5:2
0.38,0.35,0.31,0.28,0.26,0.27,0.28,0.3,0.29,0.29,0.32,0.35,0.31,0.27,0.25,0.26,0.26,0.27,0.28,0.29,0.28,0.28,0.36,0.43,0.88,1.32,0.97,0.63,0.43,0.24,0.25,0.28,0.31,0.28,0.26,0.24,0.28,0.31,0.22,0.73,1.24,0.94,0.63,0.59,0.96,1.33,2.35,2.65,2.95,2.94,2.94,2.32,1.7,1.63,1.56,1.51,1.45,1.51,1.49,1.47,1.46,1.46,1.5,1.54,1.45,1.47,1.51,1.55,1.48,1.42,1.48,1.5,1.51,1.49,1.47,1.48,1.5,1.44,2.19,2.94,3.47,4.0,3.39,2.79,2.79,3.92,3.92,2.88,2.32,1.75,1.68,1.65,1.62,1.6,1.6,1.66,1.75,1.75,2.19,2.19,1.8,1.74,1.69,2.0,2.31,2.49,2.68,2.76,2.84,2.31,1.78,1.76,2.25,2.74,2.61,2.8,3.0,2.92,2.91,2.9,2.97,2.97,2.97,2.95,2.98,3.02,2.77,2.65,2.53,2.49,2.46,1.79,1.13,1.15,1.16,1.99,2.83,2.2,1.58,1.58,0.38,0.38,0.33,0.28:2
0.74,0.5,0.31,0.25,0.27,0.32,0.32,0.27,0.27,0.34,0.36,0.32,0.28,0.29,0.31,0.3,0.29,0.3,0.3,0.29,0.3,0.34,0.34,0.32,0.3,0.32,0.32,0.28,0.26,0.31,0.31,0.29,0.25,0.25,0.32,0.39,0.29,0.29,0.38,0.91,1.44,1.44,2.91,2.91,2.67,2.43,2.86,2.62,2.37,1.86,1.35,1.33,1.33,1.33,1.34,1.03,0.72,0.54,0.35,0.35,0.3,0.29,0.32,0.32,0.27,0.26,0.31,0.32,0.28,0.24,0.5,0.76,0.76,0.77,0.55,0.41,0.32,0.3,0.29,0.3,0.33,0.56,0.79,0.86,0.86,0.83,0.77,0.71,0.48,0.25,0.29,0.3,0.67,1.03,1.26,1.49,1.51,1.52,1.52,1.55,1.55,1.6,1.65,1.9,1.87,1.83,1.87,1.9,2.46,3.02,3.18,3.35,3.57,3.8,3.8,3.06,3.06,2.81,2.81,1.81,1.81,1.69,2.1,2.8,3.57,3.97,4.37,2.74,1.12,0.99,0.92,0.92,0.96,1.56,2.16,2.04,1.92,1.32,0.73,0.69,0.64,0.58,0.53,0.53:2
0.3,0.3,0.35,0.23,0.23,0.24,0.26,0.25,0.24,0.25,0.25,0.28,0.31,0.28,0.25,0.3,0.35,0.33,0.3,0.27,0.24,0.27,0.29,0.27,0.25,0.26,0.28,0.26,0.25,0.24,0.22,0.27,0.32,0.31,0.3,0.3,1.67,1.67,1.62,1.62,2.95,2.95,2.61,2.27,2.6,2.92,3.23,2.72,2.21,4.3,2.91,1.51,1.51,1.37,1.37,1.99,2.61,1.94,1.28,1.32,1.35,1.32,1.3,1.3,1.4,1.4,1.44,1.48,1.57,1.65,3.26,4.88,3.53,2.18,1.9,1.9,1.89,1.79,1.69,1.66,1.63,1.65,1.73,1.81,1.7,1.6,1.59,1.59,1.59,1.59,1.64,1.69,2.18,2.67,3.26,3.85,3.12,2.4,2.18,1.96,1.78,1.78,1.3,1.3,0.95,0.61,0.96,1.11,1.25,1.61,1.96,2.02,2.08,1.97,2.25,2.54,2.6,2.67,2.41,2.13,1.85,1.65,1.68,1.71,2.06,2.4,3.3,3.67,4.03,3.94,3.84,3.98,4.48,4.98,3.31,1.65,1.26,0.87,0.65,0.44,1.05,0.72,0.39,0.38:2
0.34,0.28,0.34,0.41,0.48,0.54,0.53,0.41,0.3,0.29,0.3,0.3,0.3,0.28,0.28,0.28,0.28,0.28,0.28,0.28,0.27,0.25,0.39,0.54,0.95,1.37,1.02,0.68,0.51,0.35,0.3,0.3,0.31,0.27,0.23,0.23,0.28,0.27,0.29,0.29,0.3,0.3,0.3,0.22,1.25,2.27,2.25,2.23,2.17,2.11,2.28,2.45,2.22,1.99,1.99,2.65,2.65,2.04,1.42,1.71,2.04,2.37,2.52,2.68,2.97,3.26,3.66,3.68,3.7,3.34,2.73,2.11,1.91,2.34,2.78,2.85,2.93,2.98,3.04,2.94,2.84,2.51,2.18,2.03,1.95,1.88,1.89,1.89,1.97,2.04,2.17,2.31,1.97,1.62,2.15,1.85,1.56,1.5,1.43,1.51,1.58,2.0,2.41,2.41,3.58,3.58,4.06,4.54,4.31,4.29,4.28,4.15,4.47,4.78,3.64,2.51,2.36,2.6,2.85,3.31,3.31,3.32,3.35,3.38,4.01,4.64,4.58,4.52,4.65,4.78,5.03,4.89,4.75,4.14,3.54,3.24,2.94,2.77,2.64,2.69,2.74,2.76,2.93,3.11:2
0.27,0.27,0.32,0.32,0.29,0.27,0.27,0.33,0.3,0.3,0.29,0.28,0.27,0.26,0.26,0.28,0.3,0.3,0.33,0.33,0.33,0.32,0.28,0.27,0.26,0.27,0.73,1.19,1.19,0.86,0.86,0.56,0.26,0.25,0.23,0.26,0.28,0.28,0.28,0.3,0.33,1.23,2.12,2.02,2.02,2.19,2.19,2.09,1.99,1.97,1.94,1.87,1.72,1.57,1.45,1.33,1.35,1.32,1.29,1.31,1.33,1.35,1.35,1.37,1.37,1.37,1.35,1.32,1.35,1.38,1.4,1.75,2.11,3.67,3.09,2.52,1.97,1.43,2.11,2.8,6.64,5.26,3.88,4.34,3.95,3.56,3.06,2.57,2.03,1.49,1.57,1.6,1.63,1.67,1.71,1.65,1.54,1.43,1.43,1.44,1.45,1.47,1.45,1.46,1.46,1.46,1.55,1.64,1.93,2.22,2.48,2.74,2.72,2.71,2.48,2.24,2.3,2.36,2.44,2.53,2.17,1.81,1.66,1.5,1.55,1.6,1.85,2.1,1.83,1.65,1.47,2.32,3.16,2.77,2.29,1.81,1.67,1.53,1.09,0.65,0.52,0.39,0.31,0.23:2
0.53,0.54,0.52,0.53,0.55,0.57,0.53,0.49,0.48,0.5,0.49,0.48,0.47,0.48,0.52,0.51,0.49,0.48,0.52,0.56,0.56,0.51,0.43,0.34,0.28,0.27,0.3,0.31,0.28,0.26,0.29,0.31,0.29,0.28,0.33,0.89,1.45,1.07,0.71,0.35,0.31,0.26,0.26,0.31,0.31,0.26,0.25,0.3,1.36,2.42,2.42,1.24,1.24,0.92,0.92,1.61,1.61,1.46,1.32,1.36,1.42,1.43,1.4,1.36,1.22,1.08,0.7,0.32,0.4,0.46,0.49,0.51,1.15,1.79,1.76,1.79,1.75,1.72,1.74,1.71,1.67,3.01,4.36,4.55,4.74,4.53,4.33,3.96,3.96,3.76,3.76,3.27,2.47,1.68,1.58,1.69,1.81,2.26,2.71,2.8,2.9,2.86,2.82,2.09,2.35,2.61,2.94,3.28,3.76,4.24,4.69,5.14,5.28,4.78,4.27,4.2,3.23,2.25,2.15,2.04,2.04,2.03,2.59,3.14,3.14,4.01,4.01,3.5,2.98,2.8,2.67,2.59,2.54,2.67,2.8,2.77,2.74,2.18,1.65,1.13,0.84,0.55,0.57,0.57:2
1.51,1.59,1.56,1.53,1.89,2.26,1.41,0.88,0.34,0.33,0.32,0.32,0.31,0.34,0.36,0.31,0.26,0.3,0.35,0.34,0.32,0.35,0.38,0.34,0.3,0.31,0.32,0.32,0.29,0.29,0.29,0.26,0.26,0.25,0.27,0.28,0.27,0.3,0.33,0.34,0.36,0.36,0.37,0.37,1.31,2.26,2.35,2.43,2.34,2.24,2.19,2.15,2.12,2.09,1.98,1.73,1.47,1.45,1.42,1.57,1.72,1.61,1.5,1.95,2.39,2.84,3.29,3.0,3.0,1.33,1.33,1.32,1.3,1.35,1.41,1.41,1.47,1.47,1.44,1.44,1.64,1.64,1.82,1.99,1.74,1.49,2.08,2.67,2.5,2.34,1.99,1.63,1.71,1.71,4.47,4.47,3.9,3.34,2.94,2.54,2.05,1.57,1.49,1.4,1.4,2.09,2.78,2.65,2.48,2.31,2.23,2.14,2.05,1.85,1.66,2.18,2.71,2.85,2.84,2.83,2.59,2.35,1.69,1.57,1.45,1.65,1.86,1.86,1.36,1.36,2.0,2.65,2.41,2.18,1.82,1.45,0.94,0.63,0.31,0.42,0.43,0.44,0.35,0.27:2
0.4,0.31,0.26,0.31,0.3,0.29,0.34,0.4,0.37,0.33,0.3,0.31,0.87,1.44,1.32,1.19,0.81,0.42,0.35,0.29,0.27,0.33,0.29,0.25,0.27,0.31,0.31,0.31,0.29,0.3,0.32,0.3,0.29,0.29,0.33,0.35,0.35,0.3,0.31,0.35,1.03,1.7,2.09,2.48,2.62,2.72,3.15,3.58,3.17,2.77,2.82,2.87,2.16,1.44,2.0,2.56,2.01,1.47,1.41,1.35,1.78,2.21,1.74,1.27,1.35,1.4,1.38,1.32,1.31,1.37,1.35,1.33,1.32,1.33,1.35,1.36,1.32,1.32,1.35,1.34,1.32,1.31,1.35,1.39,1.4,1.35,1.33,1.35,1.36,1.34,1.32,1.34,1.39,1.41,1.38,1.39,1.39,1.38,1.34,1.32,1.35,1.36,1.35,1.34,1.48,1.62,1.4,1.18,0.92,0.66,0.99,1.31,1.64,2.81,3.97,3.47,2.97,2.77,2.57,2.08,2.66,3.23,5.43,7.64,6.35,5.07,4.36,3.65,2.69,1.74,1.72,1.69,1.24,0.8,1.02,1.22,1.41,1.97,2.54,1.79,1.04,0.7,0.37,0.31:2
1.17,1.48,1.79,2.09,2.4,2.39,2.39,2.44,2.43,2.36,2.33,2.35,2.39,2.38,2.39,2.4,2.41,2.38,2.41,2.44,2.47,2.42,2.4,2.39,2.4,2.39,2.4,2.41,2.41,2.38,2.39,2.38,2.4,2.4,2.43,2.42,2.39,2.37,2.39,2.39,2.36,2.35,2.36,2.36,2.31,2.31,2.35,2.38,2.35,2.33,2.35,2.34,2.3,2.3,2.33,2.33,2.28,2.29,2.4,2.6,2.97,3.35,3.07,2.78,2.78,0.5,0.5,0.34,0.28,0.31,0.37,0.36,0.33,0.34,0.38,0.39,0.36,0.36,0.35,0.34,0.29,0.31,0.34,0.33,0.3,0.32,0.38,0.41,0.43,0.48,0.52,0.49,0.43,0.44,0.46,0.45,0.41,0.44,0.5,0.88,1.3,1.55,1.71,1.87,2.11,2.35,2.39,2.45,2.5,2.52,2.4,2.29,2.23,2.45,2.67,2.67,1.34,1.34,1.38,1.38,1.75,2.12,3.17,4.22,4.15,3.06,1.96,2.08,2.21,2.69,3.17,3.48,3.79,3.06,2.33,2.09,1.86,1.8,1.74,1.68,1.69,1.69,1.7,1.71:2
0.94,1.09,1.07,1.17,1.23,1.39,1.3,1.15,0.99,0.91,0.97,0.98,0.96,0.95,1.01,1.22,1.28,1.24,1.24,1.23,1.39,1.35,1.3,1.29,1.36,1.72,1.87,2.07,1.98,1.94,1.88,1.73,1.38,1.23,1.18,1.06,0.92,0.99,0.87,0.94,0.84,0.85,0.95,0.88,0.94,0.82,0.92,0.9,0.83,0.98,1.32,1.67,1.51,1.38,1.52,1.46,1.4,1.14,1.09,1.11,1.61,2.16,2.72,3.28,2.99,2.7,2.41,2.21,2.2,2.1,2.13,2.01,2.95,3.89,3.1,3.8,4.5,4.67,4.43,3.64,2.81,2.37,2.2,2.32,2.35,2.49,2.48,2.39,2.54,2.47,2.27,1.48,1.99,2.49,2.39,2.06,1.67,1.57,1.45,1.42,1.65,2.02,2.17,2.13,2.21,2.35,2.66,2.77,2.84,2.6,2.62,2.64,2.65,2.67,2.91,3.46,3.58,3.06,2.15,2.01,2.69,3.45,3.85,3.64,3.43,3.07,3.13,3.49,3.09,2.14,1.3,1.01,0.78,0.54,0.37,0.28,0.28,0.29,0.29,0.26,0.27,0.28,0.29,0.28:2
0.25,0.29,0.33,0.33,0.32,0.34,0.35,0.35,0.34,0.29,0.23,0.16,0.22,0.29,0.24,0.19,0.16,0.2,0.24,0.24,0.23,0.19,0.17,0.19,0.23,0.27,0.19,0.12,0.21,0.3,0.28,0.76,1.23,1.28,0.78,0.28,0.27,0.25,0.23,0.22,0.23,0.5,0.77,0.44,0.12,0.16,0.21,0.2,0.24,0.28,0.48,0.67,0.99,1.32,1.2,1.11,1.02,0.93,0.85,2.0,3.14,2.88,2.24,1.61,1.5,1.39,1.47,1.55,1.59,1.61,1.64,1.61,1.59,1.6,1.61,1.61,1.64,1.67,1.82,1.96,2.01,2.06,1.87,1.68,1.49,1.29,1.53,1.67,1.81,1.89,1.98,1.75,1.52,2.49,2.49,1.03,1.03,1.0,0.97,1.74,2.52,2.51,2.49,3.28,4.07,2.6,1.12,1.56,1.99,2.19,2.39,2.38,2.92,3.47,3.47,2.42,2.42,2.42,3.15,3.15,3.17,3.18,3.38,3.33,3.28,2.95,2.62,2.47,2.32,1.77,1.23,1.17,1.32,1.47,1.23,0.98,0.99,1.0,1.26,1.52,1.79,1.95,2.1,2.05:2
1.49,1.29,1.1,0.71,0.33,0.28,0.23,0.27,0.3,0.32,0.33,0.33,0.32,0.3,0.28,0.3,0.29,0.27,0.27,0.27,0.27,0.27,0.27,0.3,0.33,0.34,0.32,0.33,0.33,0.29,0.24,0.27,0.32,0.31,0.3,0.3,0.3,0.26,0.23,0.25,0.31,0.41,0.79,1.18,1.14,1.1,1.5,1.9,2.22,1.96,1.7,1.58,1.62,1.66,1.49,1.32,1.34,1.37,1.37,1.37,1.36,1.36,1.35,1.32,1.28,1.37,1.46,1.42,1.37,2.64,3.91,3.89,2.67,1.46,0.92,0.38,0.39,0.37,0.35,0.37,0.38,0.35,0.32,0.33,0.33,1.42,1.42,0.91,0.4,0.44,0.47,0.42,1.64,2.86,1.57,0.27,0.26,0.3,0.33,0.32,0.31,0.34,0.36,0.36,0.52,0.52,0.57,0.61,0.79,0.96,0.96,2.1,2.1,2.04,1.99,2.79,3.59,4.31,5.02,4.87,4.74,3.54,2.34,2.84,3.34,3.3,3.25,2.96,2.92,2.89,3.13,3.01,2.9,2.88,3.12,3.36,3.36,1.61,1.61,1.41,0.89,0.37,0.71,1.05:2
2.37,2.37,2.37,1.9,1.43,1.43,1.44,1.44,1.42,2.24,3.06,2.5,1.95,1.8,1.66,1.69,1.67,1.62,1.56,1.53,1.5,1.09,0.67,0.5,0.33,0.28,0.27,0.31,0.31,0.27,0.26,0.28,0.32,0.33,0.33,0.34,0.38,0.35,0.28,0.26,0.3,0.31,0.27,0.24,0.24,0.98,1.72,2.63,2.82,3.01,2.48,2.12,1.77,1.69,1.62,1.65,1.67,1.68,1.7,1.74,1.78,1.87,1.94,1.96,1.91,1.89,1.91,1.93,1.9,1.82,1.71,1.61,1.51,1.51,1.52,1.33,1.15,1.27,1.4,1.39,1.38,1.39,1.4,1.4,1.4,1.47,1.54,1.54,1.51,1.5,1.49,1.5,1.51,1.49,1.43,1.43,0.33,0.33,0.27,0.3,0.37,0.45,2.27,4.1,4.21,4.32,3.54,2.77,2.65,2.91,3.18,3.21,3.89,4.58,4.23,3.88,3.58,3.29,2.73,2.18,2.11,2.04,2.09,2.14,2.17,2.56,2.95,3.16,3.43,3.7,5.05,6.41,6.32,6.15,5.97,4.15,2.33,2.12,1.97,1.91,2.35,2.79,2.79,2.79:2
0.84,0.75,0.71,0.73,0.79,0.85,0.75,0.73,0.76,0.76,0.72,0.74,0.76,0.78,0.76,0.75,0.77,0.8,0.82,0.8,0.79,0.77,0.76,0.74,0.75,0.75,0.75,0.73,0.75,0.77,0.78,0.79,0.8,0.8,0.76,0.72,0.69,1.27,1.86,1.43,1.0,1.0,1.35,1.35,1.01,0.67,0.8,1.09,1.38,1.49,1.58,1.63,2.12,2.6,2.48,2.36,1.98,1.59,1.6,1.61,2.02,2.43,1.29,0.84,0.39,0.29,0.25,0.28,0.31,0.3,0.28,0.3,0.36,0.38,0.29,0.29,0.3,0.31,0.28,0.28,0.29,0.3,0.28,0.27,0.27,0.3,0.33,0.35,0.34,0.34,0.29,0.27,0.29,0.31,0.29,0.28,0.28,0.32,0.34,0.34,0.33,0.33,0.33,0.46,0.59,0.97,1.36,1.29,1.91,2.52,3.1,3.9,4.71,4.43,4.2,3.97,3.97,3.98,3.61,3.25,2.85,2.45,2.45,0.8,0.8,0.78,0.79,1.27,1.75,1.78,1.81,1.65,1.46,1.46,2.19,2.19,2.03,1.86,1.5,1.14,1.13,1.1,1.07,1.06:2
1.37,1.41,1.45,1.5,1.08,0.65,0.55,0.45,0.35,0.27,0.29,0.3,0.32,0.28,0.31,0.36,0.35,0.31,0.28,0.33,0.34,0.34,0.35,0.38,0.42,0.4,0.33,0.32,0.34,0.35,0.32,0.31,0.32,0.34,0.32,0.3,0.32,0.32,0.33,0.32,0.32,0.84,1.37,1.64,1.92,2.07,2.21,2.21,2.31,2.31,1.86,1.4,1.41,1.39,1.36,1.33,1.33,1.36,1.42,1.41,1.39,1.39,1.39,1.37,1.32,1.31,1.33,1.35,1.33,1.3,1.29,1.29,0.23,0.23,0.25,0.31,0.32,0.34,0.31,0.3,0.31,0.32,0.26,0.26,0.32,0.28,0.23,0.24,0.27,0.29,0.3,0.25,0.26,0.32,0.35,0.34,0.35,0.4,0.4,0.35,0.71,1.08,1.24,1.41,1.39,1.41,1.43,1.44,1.4,1.4,4.42,4.42,3.92,3.41,3.49,3.25,3.01,1.92,1.17,0.42,0.4,0.35,0.27,0.61,0.94,0.94,1.96,1.96,2.27,2.58,2.58,2.89,2.89,2.83,2.75,2.32,1.89,1.64,1.4,1.33,1.26,1.16,1.06,1.16:2
1.31,0.73,0.15,0.21,0.27,0.25,0.23,0.26,0.29,0.26,0.23,0.22,0.22,0.19,0.17,0.19,0.21,0.2,0.18,0.19,0.21,0.22,0.23,0.26,0.28,0.28,0.28,0.24,0.21,0.19,0.17,0.18,0.19,0.21,0.19,0.17,0.19,0.19,0.18,0.18,1.56,1.56,1.56,1.26,1.26,1.6,1.93,2.62,3.32,2.27,1.23,1.97,2.72,1.93,1.14,1.21,1.29,1.03,0.78,0.53,0.29,0.23,0.16,0.18,0.19,0.17,0.14,0.17,0.19,0.19,0.19,0.19,0.19,0.19,0.24,0.24,0.28,0.28,0.26,0.25,0.23,0.21,0.17,0.14,0.17,0.21,0.12,0.18,0.24,0.26,0.22,0.18,0.28,0.25,0.22,0.25,0.27,0.23,0.19,0.2,0.22,0.19,0.18,0.17,0.18,0.19,0.16,0.19,0.23,0.21,0.2,0.93,1.65,2.68,3.7,3.31,2.92,3.47,4.01,3.3,2.6,1.82,1.04,1.29,1.54,3.56,5.57,6.32,7.07,6.09,5.11,4.8,4.5,3.93,3.35,2.45,1.55,1.43,1.3,1.3,1.31,1.34,1.07,0.81:2
2.3,2.28,2.27,2.26,2.25,2.14,2.03,2.0,2.02,2.05,2.05,1.93,1.93,1.93,1.93,1.93,2.01,2.01,2.04,2.02,2.0,1.94,1.94,1.93,1.93,1.86,1.91,1.91,2.36,2.8,2.88,2.95,2.56,2.16,2.66,3.16,3.03,2.9,2.77,2.64,2.22,1.8,1.84,1.88,1.99,2.1,2.27,2.45,2.45,2.66,2.55,2.55,2.42,2.3,2.09,2.44,2.8,2.92,3.05,2.98,2.92,2.79,2.67,1.87,1.09,0.3,1.71,3.12,4.35,3.79,3.23,3.23,3.34,3.44,3.48,3.52,3.61,3.22,2.82,2.3,1.78,2.62,3.47,3.58,3.7,3.5,3.76,4.02,3.65,3.27,3.44,3.61,2.34,2.3,2.27,1.91,1.14,0.38,0.4,0.47,0.54,0.48,0.38,0.29,1.2,2.11,2.53,2.94,2.75,2.56,2.73,2.91,3.38,3.57,3.75,3.55,3.36,3.23,3.47,3.71,3.16,2.61,2.63,3.08,3.53,3.2,2.86,2.75,2.64,2.47,2.36,2.24,2.19,2.14,1.83,1.52,1.48,1.44,1.42,1.4,1.4,1.41,1.41,1.41:2
0.23,0.17,0.13,0.12,0.14,0.16,0.13,0.15,0.19,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.16,0.16,0.17,0.19,0.16,0.14,0.15,0.15,0.14,0.14,0.17,0.19,0.17,0.16,0.17,0.18,0.16,0.17,0.17,0.16,0.16,0.19,0.19,0.15,0.14,0.18,0.27,0.37,0.81,1.24,1.25,1.21,0.89,0.57,0.37,0.16,0.17,0.17,0.14,0.16,0.19,0.19,0.13,0.14,0.2,0.17,0.13,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.19,0.17,0.13,0.11,0.15,0.19,0.13,0.14,0.19,0.23,0.23,0.24,0.45,0.66,0.61,0.49,0.38,0.43,0.8,1.18,1.61,2.04,2.34,2.64,3.23,3.82,3.82,2.17,2.17,4.13,6.08,3.99,1.91,1.34,2.16,2.97,3.75,3.28,2.81,3.47,4.13,3.21,2.29,2.29,2.89,2.89,2.99,3.1,2.05,1.9,1.74,3.3,3.25,3.2,3.02,2.33,1.64,2.17,2.7,2.7,1.57,1.57,1.57,0.23,0.23,0.22,0.23,0.23,0.19,0.16,0.18,0.23,0.28:2
0.25,0.26,0.28,0.29,0.29,0.29,0.29,0.26,0.23,0.27,0.32,0.32,0.34,0.34,0.31,0.27,0.28,0.3,0.28,0.27,0.28,0.3,0.3,0.25,0.25,0.28,0.3,0.3,0.27,0.27,0.26,0.26,0.26,0.26,0.33,0.33,0.29,0.25,0.25,0.34,0.34,1.59,2.85,2.92,3.0,2.8,2.61,2.43,2.25,2.08,2.05,2.01,2.06,2.11,2.01,1.92,1.65,1.39,1.42,1.44,1.42,1.41,1.4,1.39,1.41,1.42,1.52,1.61,1.6,1.6,1.58,1.57,1.44,1.31,1.38,1.39,1.4,2.28,3.16,3.12,3.3,3.48,4.5,5.52,3.76,3.14,2.52,2.52,2.13,2.13,2.06,2.26,2.46,2.94,3.42,3.31,3.2,2.91,2.63,2.35,2.07,2.22,2.37,2.39,2.42,2.44,2.54,2.64,2.67,2.7,2.78,2.87,2.74,2.62,2.34,2.06,1.98,1.78,1.58,2.01,2.45,3.97,3.61,3.25,2.45,1.64,1.76,1.88,1.49,1.1,1.08,0.92,0.77,0.66,0.56,0.6,0.63,0.59,0.54,0.54,0.65,0.65,0.81,0.97:2
1.84,1.29,0.73,0.71,0.7,0.7,0.5,0.31,0.27,0.23,0.24,0.26,0.29,0.29,0.29,0.29,0.33,0.33,0.33,0.34,0.34,0.29,0.24,0.3,0.3,0.3,0.3,0.25,0.25,0.24,0.26,0.28,0.28,0.31,0.31,0.61,0.91,1.13,1.35,1.21,1.07,0.67,0.27,0.92,1.57,1.59,1.46,1.33,1.37,1.75,2.12,2.25,2.08,1.92,1.67,1.42,1.35,1.27,1.38,1.33,1.29,1.32,1.35,1.37,1.38,1.42,1.46,1.46,1.45,1.41,1.47,1.53,1.58,1.89,2.19,1.95,1.71,1.64,1.57,2.04,2.52,2.18,1.85,1.56,1.76,1.96,1.96,2.4,2.4,2.4,1.71,1.71,1.64,1.58,1.68,1.78,1.62,1.47,1.47,1.43,1.41,1.41,1.43,1.46,1.88,2.3,2.42,2.42,2.43,2.4,2.08,1.76,1.66,1.55,1.58,1.58,3.44,3.44,2.85,3.22,3.58,3.34,3.11,2.7,2.62,2.53,2.08,1.63,1.61,1.58,1.46,1.34,1.2,0.88,0.57,0.48,0.38,0.39,0.39,0.33,0.26,0.33,0.28,0.24:2
0.2,0.26,0.31,0.3,0.29,0.3,0.31,0.31,0.64,0.98,1.3,1.23,1.15,0.68,0.21,0.28,0.34,0.32,0.3,0.3,0.28,0.26,0.22,0.24,0.28,0.25,0.21,0.22,0.23,0.26,0.29,0.21,0.29,0.38,0.35,0.3,0.27,0.24,0.25,0.25,0.25,0.27,0.3,0.27,0.24,0.94,1.63,1.45,1.16,0.87,0.53,1.29,2.06,2.92,3.78,3.23,2.68,2.18,1.68,1.78,1.89,1.94,1.99,2.07,2.15,1.97,1.87,1.77,1.6,1.43,1.52,1.62,1.72,1.81,1.9,1.98,2.05,2.23,2.41,2.24,2.07,1.96,1.85,2.07,2.29,2.29,2.72,2.72,3.02,3.33,3.36,3.4,3.15,2.9,4.38,3.73,3.07,2.83,2.59,2.58,2.58,2.61,2.64,2.56,2.48,2.36,2.24,2.18,2.11,2.37,2.63,2.91,4.26,5.61,5.62,5.41,5.2,4.99,4.78,4.78,4.78,4.78,4.17,3.48,2.78,2.86,2.87,2.87,2.8,2.73,3.27,3.82,4.67,5.52,4.51,3.5,3.87,4.23,4.49,4.75,4.07,3.39,3.42,3.45:2
0.33,0.3,0.3,0.3,0.34,0.35,0.36,0.33,0.29,0.29,0.28,0.28,0.28,0.28,0.28,0.83,1.38,1.21,1.04,0.68,0.32,0.3,0.28,0.27,0.27,0.36,0.36,0.33,0.31,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.38,0.38,1.16,1.96,2.28,2.13,1.86,1.58,1.77,1.96,2.67,3.37,2.41,1.45,1.96,2.47,2.78,2.05,1.32,1.29,1.28,1.27,1.32,1.36,1.29,1.21,0.95,0.68,0.49,0.29,0.29,0.29,0.31,0.34,0.37,0.33,0.29,0.29,0.28,0.28,0.28,0.27,0.31,0.34,0.32,0.29,0.3,0.32,0.3,0.28,0.21,0.27,0.33,0.34,0.36,0.33,0.3,0.3,0.33,0.36,0.29,0.22,0.27,0.32,0.32,0.33,0.33,0.33,0.37,0.4,0.52,0.63,0.93,1.23,1.35,1.45,1.56,2.75,3.95,3.46,3.11,2.76,2.17,1.57,1.81,2.05,3.33,4.61,4.75,4.88,4.61,5.32,6.04,4.41,4.07,3.74,3.6,3.46,3.46,0.46,0.46,0.4,0.35,0.33,0.31,0.31,0.31,0.31:2
1.21,0.65,0.44,0.22,0.2,0.2,0.22,0.2,0.2,0.19,0.19,0.2,0.2,0.21,0.22,0.2,0.19,0.2,0.21,0.2,0.2,0.19,0.18,0.2,0.22,0.19,0.16,0.19,0.23,0.18,0.13,0.18,0.24,0.19,0.14,0.16,0.16,0.24,0.19,0.19,0.19,0.19,0.19,0.2,0.2,0.27,0.35,0.27,0.24,0.2,0.61,1.03,1.26,1.49,1.27,0.93,0.58,0.39,0.2,0.43,1.21,1.99,1.23,0.46,0.59,1.78,2.97,2.58,2.05,1.53,0.97,0.41,0.64,0.64,3.02,3.02,2.44,1.87,1.53,1.62,1.72,1.72,4.73,4.73,3.58,2.44,1.55,0.67,0.74,2.1,3.45,2.94,2.43,1.14,0.66,0.17,0.25,1.31,2.37,1.98,1.58,1.6,1.62,1.52,1.42,2.1,2.77,2.77,1.32,1.32,0.85,0.37,0.79,1.21,3.02,3.13,3.23,2.85,2.25,1.65,1.62,2.0,2.37,2.31,2.25,2.02,1.79,1.58,1.4,1.22,1.19,1.15,1.18,1.21,0.82,0.42,0.3,0.18,0.17,0.16,0.17,0.18,0.18,0.17:2
3.75,4.05,4.35,4.06,3.62,3.18,2.88,2.59,2.54,2.5,2.47,2.43,2.47,2.51,2.46,2.48,2.5,2.48,2.46,2.45,2.45,2.49,2.2,1.91,1.69,1.48,1.43,1.39,1.39,1.4,1.39,1.37,1.38,1.4,1.38,1.36,1.31,1.39,1.46,1.43,1.44,1.44,1.33,1.22,1.3,1.39,1.36,1.33,1.22,1.11,0.99,1.73,2.47,1.99,1.52,1.38,1.56,1.73,2.07,2.41,2.41,3.2,3.2,3.59,3.92,4.25,3.3,2.46,1.61,1.54,1.47,1.44,1.4,1.44,1.43,1.41,2.26,3.1,3.13,3.16,2.58,1.99,1.76,1.53,1.53,1.8,1.8,2.2,2.61,2.06,1.51,1.53,1.55,1.57,1.54,2.27,3.01,2.69,2.38,2.34,2.31,2.03,1.74,1.5,1.25,1.35,1.45,1.92,2.39,2.58,2.77,3.42,4.07,4.18,4.18,5.69,5.69,5.69,5.05,5.05,3.99,2.93,2.35,1.77,1.79,2.01,2.23,2.62,3.02,4.05,3.26,2.48,2.42,2.37,2.28,2.25,2.25,2.23,2.22,1.39,0.55,0.56,0.56,0.44:2
0.53,0.54,0.55,0.55,0.55,0.55,0.48,0.41,0.45,0.48,0.46,0.43,0.45,0.47,0.51,0.55,0.5,0.45,0.45,0.45,0.44,0.43,0.44,0.45,0.44,0.42,0.43,0.44,0.44,0.44,0.61,0.78,1.2,1.63,1.38,0.89,0.41,0.69,0.98,1.37,1.76,2.21,2.66,2.28,1.91,2.11,2.31,2.23,2.15,1.97,1.79,1.65,1.52,1.4,1.28,1.31,1.34,1.36,1.31,1.36,1.41,1.39,1.37,1.38,1.39,1.39,1.39,1.39,3.34,3.34,3.75,2.81,1.88,1.79,1.71,2.12,2.54,1.98,1.42,1.42,1.47,1.51,1.48,1.44,1.67,1.89,1.75,1.29,0.83,0.69,0.55,0.49,0.56,0.62,0.55,0.44,0.33,0.44,0.54,0.64,0.67,0.7,0.75,0.8,0.68,0.56,0.42,0.79,1.17,1.53,1.82,2.1,2.37,2.59,2.8,4.84,6.87,5.38,3.89,3.72,3.28,2.85,2.4,1.95,2.86,3.29,3.73,3.74,3.76,3.56,3.12,2.67,2.33,1.98,1.46,0.94,0.7,0.63,0.56,0.54,0.49,0.43,0.47,0.5:2
0.77,0.49,0.2,0.17,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.15,0.19,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.16,0.16,0.18,0.18,0.14,0.15,0.18,0.19,0.14,0.15,0.18,0.18,0.15,0.16,0.18,0.17,0.16,0.16,0.17,0.16,0.17,0.17,0.14,0.15,0.18,0.17,0.13,0.12,0.14,0.17,0.14,0.16,0.19,0.16,0.1,0.46,0.83,0.98,1.13,1.19,0.76,0.34,0.24,0.17,0.13,0.11,0.97,1.82,1.82,2.13,2.13,1.62,1.12,1.96,2.8,2.12,1.45,1.01,0.5,0.18,0.31,0.45,0.32,0.2,0.21,0.24,0.31,0.38,0.33,0.28,0.22,0.21,0.46,0.83,1.15,1.18,1.09,1.0,0.59,0.18,0.21,0.21,0.15,0.32,0.5,0.49,0.47,0.36,0.28,0.23,0.16,0.71,1.27,1.3,1.38,1.87,2.37,2.01,1.66,1.57,1.47,1.28,1.42,1.57,1.57,1.28,1.28,1.19,1.06,0.93,0.71,0.48,0.45,0.38,0.24,0.18,0.2,0.2,0.16:1
2.78,2.34,1.89,1.45,1.33,1.22,1.19,1.19,1.21,1.26,0.7,0.13,0.17,0.21,0.24,0.21,0.18,0.21,0.21,0.2,0.21,0.22,0.23,0.25,0.26,0.23,0.16,0.13,0.19,0.26,0.19,0.16,0.22,0.23,0.21,0.2,0.21,0.2,0.2,0.21,0.2,0.18,0.19,0.22,0.23,0.16,0.18,0.24,0.22,0.18,0.17,0.2,0.22,0.52,0.82,1.03,1.25,1.31,1.39,1.54,1.68,2.06,2.43,1.95,1.47,1.59,1.65,1.67,1.66,1.7,1.75,1.6,1.45,1.33,1.24,1.19,1.15,1.18,1.26,0.72,0.17,0.17,0.18,0.21,0.19,0.18,0.18,0.18,0.17,0.19,0.2,0.19,0.14,0.18,0.23,0.23,0.17,0.16,0.18,0.22,0.2,0.18,0.17,0.19,0.19,0.2,0.22,0.22,0.17,0.16,0.18,0.24,0.23,0.17,0.15,0.18,0.2,0.19,0.19,0.2,0.18,0.16,0.18,0.23,0.23,0.18,0.15,0.17,0.22,0.21,0.18,0.17,0.18,0.19,0.19,0.21,0.71,1.2,1.12,0.9,0.68,0.4,0.11,0.12:1
0.14,0.19,0.19,0.16,0.16,0.18,0.17,0.16,0.17,0.17,0.16,0.18,0.18,0.14,0.13,0.16,0.19,0.14,0.15,0.18,0.18,0.15,0.16,0.19,0.17,0.16,0.16,0.17,0.16,0.18,0.17,0.14,0.15,0.17,0.18,0.1,0.37,0.64,0.89,1.14,1.19,1.24,0.68,0.12,0.16,0.17,0.16,0.18,0.16,0.14,0.15,0.16,0.16,0.13,0.16,0.14,0.12,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.17,0.22,0.25,0.25,0.27,0.29,0.17,0.13,0.17,0.18,0.16,0.15,0.16,0.16,0.16,0.18,0.16,0.14,0.16,0.18,0.16,0.13,0.17,0.14,0.1,0.13,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.18,0.15,0.15,0.18,0.2,0.18,0.2,0.22,0.21,0.2,0.22,0.71,1.2,1.21,1.26,1.33,1.41,1.48,1.15,0.83,0.62,0.4,0.37,0.32,0.26,0.23,0.25,0.24,0.23,0.23,0.25,0.25,0.21,0.22,0.26,0.29,0.39,0.48,0.62,0.39,0.17,0.14,0.7,1.25,1.21,1.2,1.24:1
0.79,0.6,0.4,0.26,0.12,0.13,0.14,0.23,0.32,0.26,0.19,0.19,0.28,0.28,0.28,0.25,0.23,0.24,0.26,0.29,0.29,0.23,0.15,0.12,0.22,0.22,0.19,0.15,0.15,0.16,0.16,0.19,0.22,0.17,0.11,0.16,0.21,0.25,0.29,0.27,0.24,1.09,1.94,1.7,1.46,1.39,1.39,1.39,1.37,1.34,1.32,1.24,1.16,1.19,1.22,1.23,1.23,1.19,1.14,1.03,0.92,0.56,0.21,0.2,0.18,0.21,0.23,0.29,0.27,0.24,0.24,0.23,0.23,0.27,0.31,0.25,0.18,0.19,0.22,0.25,0.21,0.18,0.15,0.15,0.17,0.2,0.2,0.19,0.18,0.18,0.18,0.22,0.2,0.19,0.17,0.27,0.37,0.36,0.35,0.28,0.21,0.21,0.32,0.43,0.31,0.27,0.23,0.79,1.35,1.32,0.99,0.67,0.41,0.15,0.2,0.2,0.25,0.14,0.14,0.93,1.73,1.67,1.15,0.63,0.62,0.61,1.28,1.95,2.93,3.92,3.74,3.39,3.04,3.66,4.29,2.67,1.05,1.62,2.18,1.52,0.86,0.86,2.09,2.09:1
2.08,1.85,1.61,1.47,1.0,0.54,0.44,0.34,0.34,0.35,0.31,0.24,0.24,0.25,0.24,0.23,0.21,0.19,0.17,0.14,0.16,0.19,0.17,0.23,0.28,0.28,0.26,0.26,0.21,0.16,0.16,0.23,0.24,0.24,0.24,0.25,0.22,0.23,0.24,0.23,0.22,0.25,1.44,2.63,2.01,1.38,1.36,1.33,1.32,1.31,1.3,1.29,1.29,1.29,0.88,0.47,0.32,0.17,0.15,0.13,0.13,0.22,0.29,0.2,0.2,0.22,0.24,0.24,0.2,0.22,0.22,0.21,0.2,0.25,0.24,0.23,0.23,0.22,0.18,0.23,0.28,0.28,0.27,0.27,0.27,0.24,0.2,0.2,0.16,0.16,0.15,0.13,0.57,1.01,1.21,1.07,0.93,0.55,0.16,0.17,0.19,0.22,0.22,0.23,0.25,0.28,0.26,0.24,0.24,0.2,0.2,0.25,0.29,1.14,1.99,1.27,0.54,0.43,0.46,0.48,0.44,0.4,0.48,0.58,0.67,0.57,0.47,0.48,0.58,0.67,2.2,3.72,3.98,4.23,3.6,2.97,2.22,2.22,0.36,0.36,0.4,0.36,0.33,0.35:1
0.32,0.35,0.33,0.26,0.22,0.24,0.27,0.28,0.23,0.23,0.26,0.25,0.24,0.22,0.27,0.35,0.36,0.3,0.22,0.49,0.76,1.01,1.26,1.28,1.31,1.34,0.78,0.22,0.25,0.29,0.33,0.32,0.29,0.28,0.27,0.27,0.25,0.26,0.27,0.28,0.26,0.25,0.27,0.27,0.28,0.29,0.32,0.34,0.31,0.26,0.24,0.26,0.28,0.26,0.24,0.24,0.27,0.28,0.25,0.24,0.28,0.34,0.34,0.29,0.25,0.27,0.29,0.26,0.23,0.25,0.29,0.29,0.25,0.22,0.26,0.3,0.33,0.3,0.28,0.26,0.25,0.24,0.22,0.24,0.3,0.64,0.99,1.13,1.28,1.35,1.38,0.84,0.3,0.34,0.33,0.28,0.23,0.24,0.28,0.29,0.26,0.23,0.25,0.28,0.28,0.24,0.27,0.32,0.35,0.31,0.25,0.25,0.26,0.27,0.25,0.25,0.26,0.27,0.26,0.24,0.26,0.28,0.31,0.32,0.31,0.3,0.27,0.25,0.24,0.26,0.29,0.27,0.24,0.24,0.28,0.3,0.28,0.27,0.32,0.36,0.33,0.27,0.23,0.25:1
0.12,0.23,0.2,0.17,0.14,0.15,0.21,0.25,0.29,0.24,0.23,0.23,0.25,0.27,0.27,0.26,0.24,0.21,0.22,0.25,0.25,0.19,0.14,0.12,0.13,0.19,0.25,0.17,0.13,0.15,0.2,0.23,0.2,0.17,0.16,0.73,1.3,1.33,1.33,1.01,0.69,0.47,0.25,0.29,0.26,0.23,0.19,0.21,0.25,0.21,0.17,0.13,0.13,0.18,0.21,0.21,0.16,0.15,0.16,0.19,0.2,0.21,0.2,0.2,0.21,0.24,0.28,0.28,0.25,0.5,0.77,0.63,0.36,0.3,0.24,0.21,0.23,0.24,0.22,0.19,0.17,0.16,0.17,0.18,0.21,0.21,0.18,0.14,0.14,0.2,0.2,0.21,0.2,0.2,0.23,0.26,0.29,0.24,0.23,0.23,0.27,0.33,0.88,1.43,1.36,1.33,1.34,1.34,1.34,1.31,1.27,0.73,0.19,0.26,0.25,0.22,0.16,0.15,0.19,0.23,0.27,0.23,0.22,0.26,0.3,0.32,0.28,0.25,0.25,0.26,0.28,0.29,0.29,0.26,0.22,0.21,0.22,0.25,0.23,0.17,0.14,0.14,0.2,0.27:1
0.16,0.16,0.17,0.16,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.14,0.17,0.18,0.16,0.17,0.16,0.16,0.16,0.19,0.17,0.13,0.11,0.14,0.18,0.13,0.15,0.19,0.18,0.15,0.15,0.17,0.16,0.16,0.18,0.16,0.14,0.17,0.19,0.16,0.13,0.14,0.67,1.21,1.19,1.21,0.94,0.67,0.43,0.2,0.16,0.16,0.17,0.18,0.15,0.14,0.18,0.18,0.15,0.13,0.17,0.19,0.16,0.14,0.16,0.17,0.16,0.17,0.17,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.15,0.14,0.17,0.19,0.17,0.17,0.16,0.15,0.16,0.19,0.18,0.13,0.15,0.19,0.19,0.14,0.13,0.18,0.19,0.16,0.15,0.17,0.17,0.17,0.18,0.17,0.15,0.16,0.19,0.18,0.13,0.14,0.2,0.2,0.1,0.69,1.27,1.26,1.21,0.94,0.66,0.42,0.18,0.19,0.17,0.14,0.14,0.16,0.18,0.13,0.15,0.19,0.19,0.15,0.15,0.18,0.17,0.16,0.17,0.16,0.15,0.15:1
0.32,0.37,0.31,0.26,0.3,0.34,0.32,0.31,0.31,0.31,0.31,0.32,0.32,0.27,0.28,0.28,0.32,0.31,0.3,0.3,0.29,0.3,0.32,0.28,0.24,0.31,0.39,0.3,0.22,0.25,0.28,0.31,0.3,0.29,0.31,0.32,0.69,1.06,1.35,0.87,0.39,0.62,0.85,0.79,0.73,0.82,0.92,1.28,1.65,1.92,2.9,3.88,2.24,0.6,1.24,1.88,1.64,0.94,0.25,0.28,0.29,0.31,0.28,0.36,0.44,0.38,0.31,0.31,0.23,0.31,0.31,0.31,0.42,0.42,0.44,0.45,0.91,1.36,1.39,1.12,0.86,0.58,0.31,0.35,0.4,0.42,0.44,0.46,0.41,0.36,0.34,0.31,0.36,0.4,0.37,0.34,0.32,0.27,0.23,0.25,0.28,0.31,0.34,0.28,0.23,0.27,0.31,0.22,0.29,0.36,0.33,0.29,0.41,0.53,0.53,1.32,2.12,2.17,2.22,3.42,4.62,3.11,1.61,2.33,2.33,4.54,4.54,4.15,3.77,3.3,3.3,0.64,0.64,0.67,0.77,0.88,0.78,0.68,0.53,0.39,0.38,0.37,0.34,0.31:1
0.23,0.3,0.3,0.25,0.22,0.24,0.3,0.37,0.28,0.26,0.28,0.29,0.26,0.24,0.25,0.27,0.28,0.25,0.25,0.27,0.29,0.31,0.31,0.32,0.29,0.27,0.25,0.26,0.28,0.27,0.25,0.24,0.27,0.28,0.26,0.25,0.29,0.37,0.32,0.25,0.23,0.26,0.27,0.28,0.24,0.24,0.28,0.26,0.24,0.22,0.25,0.33,0.31,0.29,0.24,0.82,1.4,1.36,1.29,1.09,0.89,0.58,0.27,0.24,0.25,0.27,0.31,0.31,0.32,0.31,0.3,0.28,0.26,0.27,0.28,0.28,0.27,0.26,0.28,0.27,0.26,0.26,0.32,0.37,0.34,0.28,0.25,0.29,0.29,0.26,0.24,0.26,0.29,0.29,0.25,0.23,0.25,0.3,0.35,0.3,0.28,0.29,0.26,0.22,0.22,0.25,0.3,0.3,0.26,0.23,0.27,0.29,0.3,0.29,0.31,0.32,0.3,0.26,0.22,0.81,1.4,1.36,1.33,1.34,1.37,0.8,0.23,0.27,0.29,0.31,0.33,0.28,0.26,0.28,0.27,0.25,0.25,0.28,0.3,0.28,0.25,0.25,0.31,0.38:1
1.47,1.38,1.3,1.04,0.77,0.51,0.25,0.27,0.29,0.27,0.23,0.21,0.24,0.24,0.23,0.3,0.31,0.33,0.28,0.23,0.22,0.25,0.26,0.27,0.25,0.21,0.24,0.28,0.23,0.23,0.27,0.3,0.28,0.25,0.25,0.27,0.26,0.23,0.23,0.28,0.3,0.29,0.27,0.25,0.28,0.26,0.24,0.24,0.24,0.25,0.25,0.23,0.24,0.26,0.26,0.24,0.24,0.25,0.24,0.22,0.23,0.24,0.25,0.26,0.22,0.78,1.33,1.3,1.27,1.3,1.06,0.82,0.54,0.25,0.27,0.29,0.3,0.27,0.23,0.23,0.26,0.27,0.26,0.26,0.28,0.3,0.28,0.24,0.23,0.28,0.33,0.31,0.29,0.28,0.29,0.27,0.23,0.22,0.27,0.25,0.23,0.22,0.21,0.23,0.25,0.22,0.2,0.29,0.38,0.3,0.25,0.23,0.24,0.25,0.22,0.23,0.27,0.29,0.28,0.25,0.25,0.26,0.25,0.23,0.24,0.25,0.26,0.27,0.25,0.26,0.27,0.27,0.25,0.77,1.3,1.32,1.35,1.16,0.97,0.63,0.29,0.24,0.23,0.25:1
2.04,1.92,1.81,1.72,1.52,1.32,0.98,0.65,0.46,0.27,0.28,0.32,0.36,0.33,0.29,0.29,0.28,0.22,0.15,0.16,0.17,0.17,0.18,0.2,0.18,0.17,0.17,0.18,0.15,0.13,0.15,0.17,0.16,0.14,0.17,0.2,0.18,0.16,0.16,0.16,0.17,0.19,0.22,0.25,0.31,0.36,0.88,1.4,1.37,1.6,1.84,2.51,3.17,2.59,2.0,1.98,1.77,1.56,1.46,1.47,1.48,1.45,1.38,1.31,2.01,2.72,2.83,2.95,2.09,1.23,1.23,1.25,1.25,1.23,1.21,1.26,1.3,1.27,1.25,1.25,0.19,0.19,0.23,0.26,0.26,0.22,0.18,0.18,0.17,0.18,0.18,0.18,0.18,0.18,0.19,0.2,0.16,0.12,0.16,0.2,0.16,0.13,0.18,0.23,0.19,0.15,0.17,0.19,0.18,0.17,0.2,0.19,0.18,0.19,0.2,0.17,0.14,0.16,0.18,0.16,0.13,0.17,0.2,0.18,0.15,0.18,0.22,0.19,0.17,0.17,0.17,0.17,0.19,0.2,0.18,0.17,0.18,0.18,0.11,0.64,1.18,1.99,2.8,2.67:1
0.27,0.24,0.26,0.2,0.2,0.25,0.29,0.31,0.33,0.33,0.29,0.32,0.29,0.29,0.27,0.25,0.27,0.29,0.3,0.26,0.22,0.21,0.21,0.21,0.26,0.23,0.33,0.33,0.34,0.35,0.32,0.32,0.32,0.36,0.28,0.2,0.21,0.21,0.21,0.24,0.24,0.43,0.61,0.97,1.32,0.97,0.64,0.32,0.28,0.24,0.49,0.75,0.58,0.4,0.39,0.34,0.29,0.29,0.28,0.28,0.3,0.32,0.32,0.38,0.38,0.37,0.36,0.36,0.36,0.38,0.34,0.31,0.37,0.42,0.43,0.43,0.71,0.99,1.14,1.29,1.16,1.03,0.69,0.34,0.55,0.76,1.1,1.45,2.12,2.12,1.04,1.04,1.73,2.41,1.4,0.4,0.38,0.37,0.46,0.54,0.51,0.25,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.03,0.05,0.03,0.0,0.05,0.1,0.33,0.55,0.48,0.55,0.62,0.65,0.68,0.68,0.75,0.75,1.34,1.92,1.77,1.61,1.5,1.5,2.13,2.13,2.01,1.9,1.75,1.6,1.49,1.38,1.37,1.36,1.35,1.34,1.34:1
0.29,0.33,0.36,0.39,0.36,0.32,0.32,0.32,0.31,0.29,0.31,0.32,0.31,0.29,0.26,0.29,0.32,0.32,0.35,0.35,0.35,0.4,0.38,0.36,0.35,0.33,0.32,0.28,0.25,0.24,0.28,0.32,0.31,0.3,0.29,0.29,0.28,0.28,0.82,1.37,1.78,2.19,2.24,2.28,2.44,2.61,2.77,2.77,2.08,2.08,2.08,2.07,1.78,1.49,1.49,1.41,1.41,1.41,1.39,1.39,1.58,1.77,1.86,1.95,1.37,0.8,0.8,0.55,0.53,0.53,0.53,0.9,1.27,0.86,0.44,0.95,1.46,1.39,1.41,1.43,1.54,1.65,1.62,1.55,1.48,1.39,1.05,0.7,0.52,0.33,0.31,0.3,0.28,0.28,0.27,0.27,0.3,0.33,0.33,0.31,0.36,0.36,0.39,0.41,0.65,0.89,0.66,0.43,0.38,0.33,0.34,0.37,0.39,0.32,0.26,0.7,1.15,1.24,1.32,0.68,0.91,1.15,1.75,2.36,2.82,3.28,2.74,2.21,2.33,2.19,2.06,2.79,3.52,3.18,1.92,0.67,0.68,0.7,0.53,0.37,0.4,0.43,0.46,0.48:1
0.62,0.53,0.44,0.38,0.34,0.29,0.28,0.27,0.22,0.21,0.2,0.26,0.27,0.29,0.24,0.2,0.21,0.22,0.22,0.21,0.19,0.23,0.27,0.28,0.25,0.19,0.17,0.15,0.24,0.21,0.18,0.19,0.21,0.25,0.3,0.21,0.13,0.47,0.82,1.16,1.5,2.55,2.02,1.49,1.58,1.78,1.97,1.71,1.45,1.51,1.58,1.56,1.5,1.44,1.35,1.25,1.24,1.24,1.17,1.2,1.22,1.34,1.29,1.24,0.9,0.56,0.42,0.27,0.19,0.11,0.2,0.29,0.27,0.24,0.13,0.17,0.22,0.21,0.21,0.17,0.12,0.21,0.25,0.29,0.29,0.18,0.18,0.19,0.2,0.21,0.2,0.19,0.21,0.23,0.24,0.22,0.18,0.18,0.17,0.22,0.2,0.19,0.2,0.23,0.25,0.23,0.21,0.17,0.2,0.23,0.28,0.32,0.28,0.26,0.43,0.6,0.91,1.23,0.96,0.7,0.49,0.29,0.24,0.2,0.16,0.27,0.39,0.77,1.16,0.66,0.85,1.04,0.92,0.79,0.67,0.68,0.68,0.7,0.71,0.62,0.51,0.41,0.42,0.44:1
0.44,0.33,0.23,0.18,0.19,0.23,0.26,0.25,0.24,0.22,0.21,0.2,0.19,0.15,0.7,1.26,1.2,0.79,0.38,0.25,0.18,0.19,0.22,0.2,0.18,0.2,0.21,0.2,0.21,0.19,0.19,0.22,0.22,0.17,0.18,0.22,0.21,0.18,0.19,0.21,0.21,0.69,1.17,0.8,0.43,0.66,0.88,1.11,1.33,1.22,1.12,0.88,0.64,0.39,0.15,0.18,0.19,0.19,0.2,0.17,0.17,0.2,0.2,0.16,0.17,0.2,0.2,0.18,0.18,0.19,0.19,0.2,0.18,0.17,0.19,0.2,0.17,0.16,0.2,0.21,0.18,0.17,0.19,0.19,0.19,0.19,0.17,0.18,0.2,0.19,0.16,0.19,0.2,0.18,0.17,0.18,0.19,0.19,0.19,0.17,0.18,0.21,0.21,0.16,0.16,0.53,0.88,1.16,1.28,0.89,0.5,0.35,0.21,0.17,0.19,0.2,0.19,0.16,0.2,0.21,0.19,0.18,0.19,0.19,0.19,0.2,0.18,0.18,0.21,0.21,0.17,0.17,0.21,0.2,0.18,0.18,0.48,0.67,0.61,0.32,0.24,0.18,0.2,0.18:1
2.52,2.56,2.6,2.61,2.56,2.54,2.53,2.54,2.52,2.52,2.51,2.52,2.53,2.57,2.57,2.58,2.6,2.64,2.62,2.59,2.56,2.54,2.49,2.47,2.48,2.47,2.44,2.45,2.49,2.5,2.48,2.51,2.54,2.51,2.44,2.41,2.43,2.45,2.42,2.44,2.46,2.45,2.41,2.42,2.45,2.46,2.47,2.48,2.47,2.43,2.43,2.44,2.45,2.43,2.39,2.91,3.44,3.48,3.5,3.51,3.01,2.51,2.4,2.48,2.57,2.57,2.58,2.58,2.57,2.57,2.58,2.56,2.55,2.58,2.62,2.65,2.65,2.65,2.61,2.59,2.59,2.64,1.45,0.25,0.41,0.57,0.8,1.23,1.87,2.36,2.68,2.43,2.19,1.73,1.27,1.32,1.35,1.33,1.32,1.36,1.45,1.54,1.6,1.68,1.66,1.63,1.51,1.44,1.45,1.48,1.48,1.45,1.45,1.5,1.27,1.05,0.75,0.45,0.48,0.48,0.43,0.43,0.44,0.42,0.39,0.41,0.44,0.43,0.39,0.4,0.44,0.45,0.43,0.46,0.49,0.48,0.42,0.4,0.46,0.45,0.41,0.4,0.45,0.52:1
0.22,0.26,0.28,0.3,0.3,0.29,0.29,0.28,0.27,0.27,0.27,0.3,0.19,0.19,0.2,0.22,0.26,0.21,0.15,0.13,0.2,0.27,0.23,0.19,0.19,0.13,0.3,0.3,0.81,1.33,1.28,0.98,0.69,0.49,0.3,0.32,0.33,0.35,0.36,0.63,0.89,0.58,0.27,0.26,0.62,0.98,1.1,1.22,1.22,1.17,1.26,1.25,1.25,1.23,1.2,1.2,1.21,0.86,0.52,0.39,0.26,0.26,0.25,0.29,0.27,0.24,0.24,0.26,0.26,0.28,0.3,0.24,0.19,0.19,0.23,0.26,0.18,0.16,0.14,0.14,0.22,0.22,0.18,0.15,0.15,0.19,0.22,0.23,0.24,0.21,0.17,0.24,0.32,0.29,0.26,0.23,0.19,0.22,0.26,0.3,0.3,0.22,0.22,0.22,0.22,0.22,0.2,0.17,0.17,0.2,0.22,0.74,1.26,1.22,0.94,0.67,0.48,0.29,0.16,0.18,0.21,0.26,0.28,0.31,0.25,0.19,0.22,0.25,0.29,0.28,0.26,0.24,0.24,0.24,0.23,0.22,0.18,0.15,0.17,0.19,0.24,0.19,0.14,0.12:1
1.66,1.58,1.5,0.99,0.48,0.52,0.53,0.51,0.46,0.41,0.45,0.49,0.44,0.45,0.56,0.71,0.6,0.48,0.49,0.49,0.49,0.5,0.51,0.5,0.5,0.33,0.16,0.16,0.19,0.17,0.16,0.16,0.18,0.2,0.17,0.17,0.17,0.17,0.17,0.19,0.18,0.16,0.13,0.7,1.26,1.23,1.23,1.22,1.18,1.15,1.15,1.19,1.21,1.22,1.21,1.2,1.21,1.28,1.9,2.53,2.05,1.56,1.37,1.17,1.18,1.22,1.3,1.38,1.62,1.85,1.53,1.22,1.28,1.28,1.2,2.27,3.34,2.23,1.13,1.16,1.2,1.21,1.18,1.17,1.18,1.2,1.22,1.25,1.23,1.22,1.22,1.22,1.22,1.2,1.22,1.3,0.72,0.14,0.2,0.22,0.21,0.21,0.21,0.2,0.21,0.23,0.23,0.18,0.21,0.26,0.21,0.16,0.18,0.22,0.24,0.21,0.2,0.2,0.21,0.21,0.23,0.22,0.17,0.23,0.29,0.24,0.19,0.18,0.24,0.23,0.2,0.19,0.21,0.22,0.21,0.22,0.2,0.2,0.21,0.26,0.29,1.02,1.75,1.95:1
0.24,0.26,0.31,0.36,0.4,0.3,0.26,0.3,0.31,0.29,0.29,0.3,0.33,0.31,0.29,0.27,0.28,0.31,0.35,0.33,0.27,0.27,0.31,0.31,0.28,0.28,0.33,0.36,0.31,0.26,0.25,0.3,0.32,0.32,0.28,0.23,0.27,0.32,0.71,1.11,1.11,2.71,2.71,2.25,2.46,2.68,2.73,2.79,2.75,2.71,2.21,1.71,1.66,1.61,1.5,1.4,1.5,1.91,2.33,1.86,1.4,1.33,1.28,1.3,1.36,1.42,1.42,1.43,1.4,1.38,1.34,1.35,1.36,1.4,1.41,1.42,1.4,1.38,1.37,1.36,1.42,1.48,1.38,1.28,0.94,0.63,0.25,0.29,0.34,0.36,0.35,0.33,0.32,0.36,0.43,0.41,0.37,0.33,0.34,0.32,0.28,0.24,0.24,0.28,0.31,0.24,0.24,0.29,0.31,0.29,0.3,0.36,0.47,0.71,0.95,1.54,2.12,2.24,2.36,2.4,2.41,2.44,2.58,2.75,2.25,1.75,1.86,2.66,3.47,3.18,2.89,2.86,2.82,2.82,0.65,0.65,0.55,0.45,0.4,0.4,0.41,0.41,0.38,0.33:1
0.11,0.18,0.25,0.54,0.83,1.03,1.22,1.32,0.76,0.19,0.23,0.27,0.18,0.18,0.18,0.18,0.18,0.16,0.15,0.16,0.16,0.18,0.21,0.23,0.25,0.23,0.22,0.21,0.2,0.19,0.18,0.18,0.18,0.16,0.16,0.18,0.2,0.21,0.23,0.25,0.29,0.53,0.77,0.61,0.45,0.64,0.83,1.04,1.25,1.22,0.86,0.49,0.42,0.36,0.3,0.25,0.29,0.33,0.32,0.31,0.35,0.4,0.36,0.32,0.29,0.26,0.27,0.48,0.69,1.02,1.34,1.12,0.9,0.6,0.29,0.26,0.31,0.36,0.38,0.4,0.31,0.41,0.5,0.46,0.41,0.39,0.39,0.39,0.4,0.31,0.38,0.44,0.39,0.34,0.37,0.4,0.43,0.47,0.45,0.43,0.42,0.4,0.39,0.37,0.38,0.39,0.38,0.38,0.42,0.41,0.4,0.53,0.67,0.67,2.78,2.78,2.22,1.66,0.92,0.17,0.21,0.5,0.79,1.22,1.22,3.19,3.19,3.03,2.87,2.87,2.96,2.96,2.96,2.71,2.71,2.71,2.15,2.15,1.59,1.03,1.27,1.5,1.44,1.37:1
0.41,0.34,0.28,0.3,0.31,0.32,0.3,0.28,0.27,0.27,0.26,0.25,0.3,0.34,0.34,0.35,0.37,0.36,0.35,0.38,0.41,0.37,0.32,0.32,0.32,0.33,0.32,0.64,0.96,1.15,1.34,1.06,0.74,0.41,0.34,0.28,0.31,0.66,1.01,1.42,1.83,2.08,2.34,2.01,1.68,1.93,2.18,2.18,2.36,2.36,2.37,2.38,2.36,2.34,2.12,1.91,2.07,2.08,2.09,1.76,1.43,1.39,1.35,1.31,1.34,1.38,1.34,1.31,1.31,1.36,1.36,1.33,1.33,1.34,1.33,1.32,1.36,1.39,1.34,1.28,1.29,1.31,1.3,1.28,1.34,1.39,1.36,1.32,1.34,1.35,1.35,1.34,1.37,1.39,1.37,1.34,1.36,1.37,1.36,1.34,1.34,1.34,1.36,1.38,1.36,1.35,1.36,1.36,1.36,0.42,0.42,0.43,0.44,0.77,1.09,1.64,2.18,1.61,1.05,1.05,1.11,1.17,1.23,1.29,1.23,1.17,1.29,1.41,1.28,1.16,1.07,0.99,0.87,0.76,0.91,0.91,0.91,0.9,0.88,0.65,0.42,0.38,0.34,0.39:1
0.39,0.34,0.28,0.21,0.22,0.27,0.32,0.29,0.27,0.33,0.31,0.3,0.25,0.21,0.29,0.27,0.26,0.21,0.29,0.37,0.35,0.33,0.27,0.21,0.27,0.33,0.27,0.21,0.28,0.35,0.34,0.32,0.28,0.32,0.36,0.31,0.26,0.21,0.23,0.26,0.3,0.9,1.5,1.5,1.5,1.5,1.76,1.76,1.76,2.11,2.11,1.72,1.33,2.43,3.54,2.37,1.21,1.25,1.29,1.29,1.29,0.84,0.4,0.35,0.36,0.36,0.3,0.23,0.28,0.33,0.28,0.27,0.25,0.31,0.36,0.32,0.29,0.3,0.31,0.3,0.28,0.28,0.27,0.3,0.31,0.31,0.3,0.31,0.33,0.3,0.27,0.27,0.28,0.31,0.29,0.26,0.32,0.37,0.36,0.34,0.26,0.28,0.3,0.31,0.3,0.27,0.3,0.33,0.38,0.35,0.32,0.31,0.29,1.72,3.14,2.31,1.48,0.95,0.42,0.49,0.55,0.4,0.24,1.61,2.99,2.9,2.81,2.74,2.67,2.54,2.4,2.32,2.24,2.61,2.98,3.22,2.75,2.27,2.27,0.42,0.42,0.36,0.29,0.31:1
0.19,0.24,0.26,0.28,0.26,0.25,0.25,0.25,0.25,0.25,0.22,0.2,0.19,0.18,0.21,0.24,0.19,0.13,0.16,0.19,0.17,0.14,0.14,0.11,0.11,0.16,0.2,0.19,0.17,0.17,0.2,0.23,0.15,0.13,0.12,0.15,0.74,1.32,1.27,0.73,0.19,0.26,0.33,0.33,1.98,1.98,1.42,1.5,1.59,1.53,1.47,1.35,1.24,1.23,1.22,1.22,1.22,1.26,1.3,1.25,1.19,0.68,0.17,0.18,0.19,0.18,0.18,0.15,0.15,0.15,0.29,0.25,0.21,0.12,0.14,0.17,0.17,0.18,0.14,0.1,0.13,0.16,0.19,0.19,0.19,0.23,0.23,0.19,0.19,0.18,0.18,0.17,0.17,0.18,0.19,0.17,0.18,0.19,0.27,0.25,0.23,0.17,0.1,0.18,0.26,0.26,0.18,0.1,0.16,0.21,0.24,0.26,0.21,0.16,0.33,0.5,0.87,1.24,1.2,1.66,2.11,1.82,1.52,1.04,0.55,0.42,0.28,0.28,0.43,0.57,0.72,0.86,0.83,0.8,0.74,0.67,0.51,0.35,0.4,0.43,0.45,0.33,0.29,0.25:1
0.31,0.29,0.27,0.3,0.33,0.32,0.32,0.32,0.3,0.28,0.28,0.29,0.28,0.27,0.31,0.35,0.34,0.33,0.32,0.35,0.37,0.3,0.24,0.31,0.28,0.26,0.26,0.32,0.32,0.31,0.3,0.29,0.27,0.28,0.29,0.28,0.28,0.31,0.35,0.46,1.57,2.69,2.78,2.88,2.87,2.87,2.67,2.48,2.48,3.57,3.57,2.5,1.42,1.42,1.3,1.3,1.64,1.98,1.98,1.24,1.24,1.34,1.33,1.31,1.31,0.26,0.26,0.26,0.3,0.3,0.29,0.27,0.29,0.29,0.29,0.24,0.26,0.28,0.25,0.21,0.26,0.31,0.21,0.37,0.54,0.52,0.44,0.37,0.37,0.37,0.31,0.31,0.36,0.36,0.41,0.46,0.64,0.82,0.85,0.89,1.09,1.29,1.35,1.41,1.38,1.34,1.34,0.3,0.3,0.21,0.62,1.03,1.04,1.06,1.37,0.83,0.29,0.67,1.1,1.54,1.53,1.55,1.57,1.54,1.51,1.84,2.17,2.67,2.57,2.47,2.05,1.64,1.67,1.71,2.4,3.08,2.66,2.66,4.3,4.3,2.54,0.79,0.79,0.79:1
0.11,0.16,0.16,0.15,0.14,0.17,0.18,0.17,0.14,0.17,0.19,0.17,0.15,0.16,0.19,0.17,0.16,0.17,0.19,0.17,0.16,0.16,0.19,0.17,0.16,0.16,0.19,0.17,0.16,0.16,0.18,0.19,0.21,0.23,0.26,0.25,0.27,0.31,0.93,1.55,3.39,2.65,1.91,1.93,1.98,2.05,2.13,1.81,1.54,1.26,1.26,1.27,1.27,1.25,1.26,1.27,1.29,1.25,1.23,0.84,0.45,0.22,0.22,0.23,0.24,0.22,0.22,0.23,0.24,0.22,0.22,0.24,0.24,0.22,0.22,0.24,0.24,0.22,0.22,0.24,0.23,0.23,0.22,0.24,0.23,0.22,0.22,0.24,0.24,0.22,0.22,0.25,1.49,2.72,2.5,2.28,2.24,2.2,1.84,1.48,1.48,3.46,3.46,3.3,3.15,3.15,1.37,1.37,1.22,1.07,0.68,0.3,0.35,0.35,0.49,0.63,0.75,1.44,2.14,2.0,1.87,1.84,3.03,4.22,4.93,5.64,4.35,3.07,2.64,2.2,2.2,0.65,0.65,0.46,0.32,0.26,0.24,0.22,0.18,0.16,0.16,0.18,0.19,0.17:1
0.23,0.26,0.74,1.22,1.56,1.89,1.78,1.67,1.48,1.28,1.2,1.16,1.21,0.89,0.57,0.35,0.13,0.18,0.21,0.2,0.18,0.18,0.18,0.17,0.18,0.21,0.2,0.16,0.16,0.19,0.23,0.2,0.16,0.15,0.2,0.21,0.18,0.16,0.18,0.19,0.19,0.21,0.26,1.04,1.83,1.79,1.59,1.39,1.32,1.29,1.28,2.15,3.02,2.64,2.27,2.25,2.23,2.19,2.17,2.11,1.99,2.15,2.3,1.8,1.29,1.3,1.32,1.33,1.3,1.26,1.67,2.08,1.64,1.2,1.24,1.27,1.25,1.21,1.2,1.21,1.22,0.69,0.15,0.23,0.24,0.23,0.24,0.27,0.26,0.2,0.17,0.23,0.24,0.22,0.21,0.22,0.21,0.21,0.23,0.25,0.22,0.18,0.2,0.25,0.26,0.21,0.18,0.23,0.24,0.22,0.2,0.21,0.21,0.22,0.23,0.22,0.19,0.21,0.25,0.25,0.2,0.17,0.21,0.23,0.23,0.22,0.2,0.23,0.22,0.21,0.21,0.21,0.2,0.21,0.24,0.22,0.18,0.17,0.21,0.25,1.17,2.1,2.1,2.1:1
0.3,0.35,0.4,0.59,0.78,1.07,1.36,1.34,0.75,0.15,0.15,0.16,0.17,0.16,0.16,0.13,0.09,0.14,0.19,0.22,0.24,0.19,0.15,0.12,0.16,0.2,0.15,0.09,0.12,0.16,0.19,0.16,0.14,0.16,0.18,0.2,0.21,1.46,2.71,2.19,1.67,1.49,1.3,1.34,1.39,1.76,2.13,2.13,1.23,1.23,0.93,0.63,0.23,0.6,0.96,0.55,0.14,0.17,0.21,0.27,0.33,0.35,0.38,0.41,0.44,0.46,0.36,0.27,0.32,0.37,0.36,0.36,0.61,0.87,1.17,1.47,1.47,0.14,0.14,0.15,0.17,0.19,0.17,0.16,0.19,0.23,0.25,0.28,0.24,0.21,0.18,0.17,0.16,0.2,0.24,0.21,0.17,0.2,0.24,0.3,0.29,0.28,0.25,0.25,0.25,0.26,0.28,0.29,0.33,0.36,0.41,0.46,0.46,0.69,0.69,0.76,0.78,0.81,0.84,0.71,0.58,0.54,0.64,0.73,0.86,0.95,1.03,1.02,1.44,1.86,1.63,1.41,1.0,0.59,0.57,0.54,0.62,0.7,0.76,0.83,0.69,0.55,0.39,0.23:1
0.31,0.32,0.3,0.28,0.27,0.31,0.31,0.31,0.27,0.27,0.3,0.29,0.3,0.31,0.33,0.3,0.28,0.26,0.28,0.29,0.31,0.31,0.3,0.29,0.29,0.27,0.28,0.45,0.62,0.98,1.34,0.84,0.57,0.29,0.27,0.29,0.34,0.33,0.26,0.26,2.3,2.3,2.13,2.48,2.82,2.82,2.24,2.24,1.79,1.35,1.37,1.36,1.31,1.32,1.35,1.34,1.28,1.26,1.32,1.38,1.36,1.32,1.31,1.35,1.34,1.29,1.3,1.37,1.38,1.33,1.3,1.31,1.35,1.01,0.68,0.5,0.33,0.31,0.29,0.27,0.27,0.29,0.32,0.32,0.3,0.29,0.31,0.3,0.26,0.26,0.33,0.35,0.32,0.28,0.29,0.32,0.3,0.25,0.28,0.36,0.35,0.28,0.24,0.29,0.3,0.27,0.3,0.37,0.41,0.39,0.64,0.89,1.05,1.21,1.51,1.8,1.8,0.66,0.66,1.67,2.68,2.68,3.16,3.16,2.95,2.73,2.47,2.21,1.85,1.48,3.03,1.77,0.52,0.47,0.44,0.45,0.45,0.4,0.37,0.37,0.37,0.34,0.3,0.26:1
0.34,0.34,0.34,0.26,0.18,0.83,1.48,1.36,0.95,0.55,0.42,0.29,0.26,0.24,0.24,0.25,0.23,0.25,0.26,0.25,0.25,0.26,0.28,0.3,0.33,0.31,0.3,0.27,0.25,0.22,0.2,0.22,0.24,0.22,0.19,0.22,0.24,0.24,0.25,1.79,3.33,2.94,2.54,2.54,1.58,1.58,1.46,1.34,1.61,1.79,1.96,1.97,1.63,1.29,1.31,1.34,1.32,1.3,1.28,1.26,1.24,1.21,0.92,0.64,0.45,0.26,0.23,0.24,0.26,0.25,0.25,0.29,0.34,0.33,0.33,0.31,0.29,0.32,0.35,0.31,0.27,0.23,0.2,1.29,2.39,0.77,0.75,0.74,1.08,1.42,1.37,1.58,1.79,1.04,0.29,0.35,0.32,0.28,0.3,0.32,0.19,0.17,0.16,0.24,0.32,0.32,0.32,0.32,0.28,0.28,0.26,0.25,0.26,0.27,0.24,0.21,0.21,0.21,0.23,0.24,0.93,1.62,2.12,2.63,2.63,1.18,1.18,1.01,0.83,0.78,0.74,0.72,0.71,0.7,0.84,0.97,1.23,1.49,1.17,0.85,0.83,0.79,0.75,0.73:1
0.23,0.17,0.13,0.12,0.14,0.16,0.13,0.15,0.19,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.16,0.16,0.17,0.19,0.16,0.14,0.15,0.15,0.14,0.14,0.17,0.19,0.17,0.16,0.17,0.18,0.16,0.17,0.17,0.16,0.16,0.19,0.19,0.15,0.14,0.18,0.27,0.37,0.81,1.24,1.25,1.21,0.89,0.57,0.37,0.16,0.17,0.17,0.14,0.16,0.19,0.19,0.13,0.14,0.2,0.17,0.13,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.19,0.17,0.13,0.11,0.15,0.19,0.13,0.14,0.19,0.23,0.23,0.24,0.45,0.66,0.61,0.49,0.38,0.43,0.8,1.18,1.61,2.04,2.34,2.64,3.23,3.82,3.82,2.17,2.17,4.13,6.08,3.99,1.91,1.34,2.16,2.97,3.75,3.28,2.81,3.47,4.13,3.21,2.29,2.29,2.89,2.89,2.99,3.1,2.05,1.9,1.74,3.3,3.25,3.2,3.02,2.33,1.64,2.17,2.7,2.7,1.57,1.57,1.57,0.23,0.23,0.22,0.23,0.23,0.19,0.16,0.18,0.23,0.28:2
0.3,0.3,0.29,0.26,0.25,0.25,0.22,0.21,0.25,0.29,0.27,0.28,0.29,0.26,0.22,0.24,0.26,0.29,0.28,0.27,0.26,0.24,0.24,0.24,0.25,0.28,0.31,0.28,0.25,0.24,0.24,0.25,0.25,0.22,0.2,0.26,0.32,0.26,0.2,0.5,0.79,1.04,1.29,1.35,1.42,0.83,0.24,0.23,0.23,0.27,0.3,0.29,0.29,0.31,0.26,0.2,0.24,0.28,0.31,0.3,0.28,0.29,0.28,0.26,0.24,0.23,0.26,0.3,0.28,0.27,0.28,0.3,0.26,0.22,0.24,0.28,0.32,0.35,0.3,0.25,0.27,0.29,0.29,0.27,0.36,0.45,0.88,1.31,1.36,1.41,1.38,1.13,0.87,0.62,0.36,0.79,1.21,0.99,0.77,0.76,0.73,0.98,1.24,1.86,2.48,2.65,2.82,2.82,4.96,4.96,5.01,5.07,4.81,4.02,3.23,2.86,2.5,2.71,2.92,2.46,2.0,1.91,1.82,1.93,1.89,1.84,1.84,1.83,2.72,3.61,4.02,4.44,3.58,2.73,1.75,0.76,0.61,0.45,0.42,0.38,0.43,0.38,0.34,0.26:2
0.38,0.34,0.33,0.33,0.32,0.32,0.34,0.29,0.25,0.28,0.3,0.28,0.25,0.29,0.33,0.32,0.3,0.27,0.24,0.27,0.31,0.24,0.28,0.33,0.28,0.24,0.24,0.33,0.36,0.31,0.31,0.32,0.33,0.33,0.29,0.26,0.3,0.29,0.28,0.82,1.35,1.38,1.42,0.89,0.37,0.33,0.31,0.29,0.27,0.26,0.55,0.84,0.84,0.78,0.78,0.86,0.94,1.15,1.35,1.36,1.37,1.37,2.13,2.89,2.31,1.73,1.47,1.84,2.22,3.44,3.85,4.25,4.28,4.36,4.44,3.79,3.14,2.41,1.67,1.51,1.34,1.44,1.54,1.62,1.56,1.5,1.52,1.54,1.5,1.46,1.52,1.58,1.47,1.51,1.55,1.74,1.92,1.97,2.03,2.44,2.86,2.57,2.29,3.06,3.82,3.35,2.87,2.87,3.3,3.3,3.3,3.27,3.27,3.27,3.26,3.26,3.23,3.2,2.88,2.56,2.6,2.13,1.66,1.65,1.63,1.61,1.6,1.58,1.6,1.61,1.59,1.57,1.59,1.6,1.61,1.62,1.63,1.65,1.65,1.57,1.57,1.6,1.62,1.67:2
1.44,1.46,1.47,1.41,1.44,1.47,1.44,1.39,1.34,1.25,1.15,0.7,0.24,0.24,0.35,0.35,0.34,0.33,0.31,0.3,0.28,0.28,0.3,0.3,0.27,0.24,0.24,0.24,0.34,0.34,0.34,0.29,0.29,0.31,0.33,0.29,0.24,0.29,0.28,0.26,0.23,0.23,0.33,0.26,0.26,0.51,0.76,0.71,0.67,1.44,2.2,2.7,3.64,4.57,5.42,5.42,3.46,3.46,2.37,1.28,0.97,0.66,1.34,2.02,1.62,1.22,1.33,1.49,1.66,2.09,2.52,2.45,2.46,2.46,2.46,3.71,3.71,3.17,2.54,1.92,1.8,1.88,1.97,2.11,3.14,4.16,3.11,2.06,2.06,1.99,1.99,2.48,2.98,2.98,1.65,1.65,1.31,0.98,1.07,1.66,2.25,2.7,3.49,4.28,4.02,3.76,3.75,3.51,3.26,2.38,1.5,1.51,1.52,1.56,1.56,1.56,1.56,1.49,1.53,1.53,1.52,1.51,1.51,1.52,1.52,1.56,1.55,1.54,1.56,1.57,1.57,1.49,1.49,1.49,1.06,0.62,0.5,0.49,0.49,0.45,0.41,0.77,1.13,1.62:2
1.41,1.14,0.87,0.59,0.32,0.34,0.32,0.3,0.31,0.31,0.29,0.3,0.31,0.3,0.29,0.3,0.31,0.29,0.28,0.27,0.33,0.33,0.35,0.35,0.32,0.29,0.28,0.26,0.28,0.3,0.27,0.23,0.26,0.3,0.27,0.24,0.33,0.43,0.78,1.14,3.14,2.56,1.97,2.07,2.16,2.35,2.54,2.32,2.11,1.73,1.36,1.39,1.41,1.43,1.39,1.34,1.37,1.41,1.62,1.83,1.83,1.79,1.79,1.72,1.54,1.37,1.36,1.36,1.43,1.43,1.21,0.99,0.69,0.39,0.47,0.68,0.88,1.05,1.27,1.49,1.45,1.41,1.41,1.39,1.39,1.4,0.84,0.28,0.29,0.28,0.28,0.32,0.37,0.34,0.31,0.32,0.33,0.36,0.4,0.35,0.31,0.31,0.32,0.43,0.54,0.58,0.61,1.13,1.64,1.85,2.07,2.37,2.66,2.65,2.64,2.28,1.92,2.07,1.91,1.75,1.58,1.5,1.42,1.17,0.92,0.75,0.58,0.59,0.58,0.56,0.56,0.55,0.55,0.94,1.33,2.66,3.99,3.43,2.87,3.19,3.51,3.53,3.56,3.67:2
0.84,2.78,3.96,5.14,3.93,2.71,3.08,3.45,2.87,2.3,2.38,2.43,2.42,2.4,2.39,2.39,2.38,2.37,2.38,2.38,2.35,2.34,2.35,2.35,2.37,2.38,2.39,2.35,2.31,2.32,2.33,2.34,2.36,2.34,2.34,2.35,2.34,2.32,2.32,2.34,2.37,2.41,2.38,2.36,2.33,2.31,2.29,2.31,2.31,2.31,2.29,2.45,2.61,3.01,3.41,3.41,2.02,2.02,2.27,2.13,1.98,1.9,1.86,1.87,1.9,1.9,1.88,1.86,1.93,1.99,1.95,2.6,3.25,3.9,4.56,4.06,3.65,3.25,2.72,3.59,4.47,5.66,4.47,3.28,2.52,1.76,1.76,1.48,1.48,1.16,0.84,0.63,0.41,0.69,1.04,1.39,2.29,3.19,3.37,3.56,3.7,3.85,3.85,2.08,2.08,2.16,2.37,2.59,2.63,2.68,2.68,2.69,2.56,2.44,2.49,2.52,2.69,2.85,2.91,2.97,2.34,1.7,1.51,1.32,1.14,1.09,1.04,0.72,0.41,0.36,0.35,0.37,0.38,0.38,0.36,0.39,0.44,0.48,0.39,0.39,0.4,0.44,0.81,1.18:2
1.46,0.92,0.59,0.27,0.3,0.29,0.25,0.25,0.27,0.28,0.25,0.27,0.27,0.3,0.31,0.33,0.31,0.27,0.25,0.27,0.3,0.28,0.24,0.26,0.3,0.31,0.29,0.3,0.33,0.32,0.27,0.24,0.26,0.28,0.27,0.25,0.27,0.27,0.26,0.24,0.92,1.61,2.25,2.88,2.81,2.8,2.11,1.41,1.34,1.34,1.34,1.3,1.31,1.42,1.26,1.09,0.68,0.27,0.26,0.26,0.26,0.28,0.27,0.24,0.25,0.3,0.33,0.3,0.26,0.28,0.28,0.26,0.27,0.33,0.36,0.29,0.25,0.26,0.3,0.33,0.36,0.38,0.36,0.83,1.3,1.47,1.55,1.55,1.14,0.72,1.07,1.42,1.7,1.9,1.83,1.75,1.65,1.56,1.47,1.43,1.41,1.42,1.43,1.47,1.56,1.72,1.93,3.14,4.35,3.13,1.9,2.02,2.07,2.4,2.74,2.74,3.27,3.27,2.59,1.92,2.0,2.08,2.08,2.01,1.98,2.04,2.11,2.12,2.39,2.65,2.03,1.59,1.34,1.35,1.41,1.42,1.32,1.27,1.26,1.37,1.48,1.27,0.79,0.32:2
1.27,0.97,0.6,0.23,0.31,0.36,0.36,0.35,0.32,0.31,0.3,0.3,0.31,0.31,0.29,0.29,0.3,0.31,0.33,0.35,0.37,0.35,0.33,0.31,0.32,0.3,0.29,0.27,0.3,0.28,0.26,0.26,0.78,1.3,1.34,1.21,1.09,0.77,0.45,1.12,1.79,2.6,3.4,2.93,2.47,2.76,2.99,3.22,3.06,2.66,2.23,1.81,1.38,1.36,1.33,1.32,1.35,1.37,1.37,1.37,1.33,1.3,1.08,0.86,0.55,0.25,0.26,0.27,0.27,0.26,0.29,0.35,0.34,0.29,0.29,0.28,0.29,0.27,0.24,0.25,0.26,0.27,0.23,0.21,0.3,0.39,0.27,0.29,0.32,0.27,0.22,0.24,0.29,0.27,0.25,0.25,0.29,0.35,0.35,0.32,0.29,0.28,0.26,0.34,0.41,0.68,0.98,1.28,2.42,2.55,2.67,2.46,2.42,2.37,2.35,2.34,2.18,2.29,2.39,2.33,2.26,2.25,2.24,2.25,2.34,2.43,2.43,1.39,1.39,1.37,1.35,1.33,1.34,1.36,1.38,1.45,1.52,1.25,0.98,0.91,0.82,0.77,0.73,0.39:2
0.27,0.26,0.27,0.28,0.26,0.23,0.42,0.62,0.6,0.59,0.59,0.6,0.6,0.58,0.56,0.55,0.54,0.42,0.29,0.26,0.27,0.28,0.28,0.32,0.32,0.92,1.53,1.53,0.29,0.29,0.26,0.25,0.23,0.25,0.27,0.3,0.26,0.23,0.55,0.88,0.69,0.51,0.52,0.53,0.62,0.71,1.24,1.78,2.79,2.79,1.7,1.7,1.84,1.85,1.87,1.71,1.54,1.65,1.76,1.75,1.76,1.78,1.75,1.82,1.89,1.8,1.6,1.4,1.36,1.36,1.37,1.41,1.46,2.28,3.09,3.09,1.86,1.86,1.81,1.75,1.79,1.76,1.73,1.63,4.34,7.05,5.46,3.87,3.6,3.32,2.43,1.53,1.53,2.01,2.01,1.74,1.47,1.47,1.4,1.4,1.39,1.38,1.39,1.39,1.39,1.38,1.36,1.38,1.4,1.42,1.67,1.93,2.05,2.17,2.18,2.2,2.21,2.62,3.04,3.65,4.26,4.35,4.45,5.09,5.7,6.32,6.4,4.61,2.83,3.01,3.01,3.84,3.84,4.53,5.21,5.21,2.46,2.46,1.84,1.21,0.93,1.34,1.76,3.1:2
0.31,0.31,0.3,0.3,0.3,0.3,0.32,0.33,0.32,0.3,0.29,0.27,0.29,0.3,0.3,0.3,0.31,0.28,0.26,0.28,0.32,0.27,0.23,0.24,0.28,0.33,0.32,0.31,0.32,0.29,0.26,0.24,0.23,0.26,0.28,0.23,0.33,0.43,0.36,0.85,1.34,1.4,1.03,0.65,0.46,0.27,0.35,0.31,0.27,0.25,0.28,0.3,0.25,0.28,0.32,0.56,0.79,0.83,0.88,0.81,0.75,0.71,0.67,0.53,0.39,0.44,0.49,0.47,0.45,0.41,0.44,0.47,0.4,0.99,1.59,3.01,4.43,3.53,2.62,2.04,1.45,1.41,1.37,1.39,1.4,1.33,1.39,1.46,1.42,1.36,1.38,1.4,1.38,1.03,0.68,0.49,0.3,0.31,0.32,0.31,0.31,0.3,0.28,0.29,0.31,0.3,0.29,0.34,0.38,0.66,0.95,0.95,2.9,2.9,2.56,2.23,2.91,3.59,2.74,2.57,2.39,3.1,3.8,3.8,3.61,3.61,2.49,2.11,1.73,1.52,1.38,1.24,1.38,1.52,0.93,0.34,0.36,0.38,0.32,0.26,0.29,0.31,0.27,0.24:2
1.21,1.13,1.14,1.16,1.15,1.14,1.14,1.17,1.17,1.36,0.99,0.63,0.53,0.43,0.33,0.22,0.22,0.32,0.32,0.34,0.36,0.85,1.35,1.37,1.11,0.84,0.59,0.33,0.28,0.24,0.24,0.24,0.26,0.28,0.28,0.28,0.3,0.33,0.25,0.27,0.28,0.28,0.31,0.31,0.3,0.3,0.29,0.29,0.29,0.34,0.34,0.77,1.19,0.76,0.32,0.29,0.25,1.13,2.01,2.01,2.08,2.08,1.74,1.39,1.38,1.37,1.41,1.46,1.47,1.48,1.41,1.35,1.47,1.59,1.28,0.97,0.97,3.4,3.4,2.54,2.16,1.78,1.71,1.64,4.51,7.38,5.62,3.86,3.86,3.25,3.25,3.24,3.23,3.23,2.33,2.33,2.33,2.59,2.59,1.64,0.69,0.66,0.62,0.56,0.5,0.58,0.85,1.13,1.32,1.5,1.25,0.99,0.31,1.47,2.62,3.14,3.65,3.34,3.02,3.49,3.95,3.5,3.04,2.59,2.38,2.16,2.2,2.23,2.13,2.02,1.89,1.77,1.79,1.74,1.69,1.13,0.57,0.48,0.39,0.36,0.32,0.32,0.33,0.34:2
0.4,0.31,0.26,0.31,0.3,0.29,0.34,0.4,0.37,0.33,0.3,0.31,0.87,1.44,1.32,1.19,0.81,0.42,0.35,0.29,0.27,0.33,0.29,0.25,0.27,0.31,0.31,0.31,0.29,0.3,0.32,0.3,0.29,0.29,0.33,0.35,0.35,0.3,0.31,0.35,1.03,1.7,2.09,2.48,2.62,2.72,3.15,3.58,3.17,2.77,2.82,2.87,2.16,1.44,2.0,2.56,2.01,1.47,1.41,1.35,1.78,2.21,1.74,1.27,1.35,1.4,1.38,1.32,1.31,1.37,1.35,1.33,1.32,1.33,1.35,1.36,1.32,1.32,1.35,1.34,1.32,1.31,1.35,1.39,1.4,1.35,1.33,1.35,1.36,1.34,1.32,1.34,1.39,1.41,1.38,1.39,1.39,1.38,1.34,1.32,1.35,1.36,1.35,1.34,1.48,1.62,1.4,1.18,0.92,0.66,0.99,1.31,1.64,2.81,3.97,3.47,2.97,2.77,2.57,2.08,2.66,3.23,5.43,7.64,6.35,5.07,4.36,3.65,2.69,1.74,1.72,1.69,1.24,0.8,1.02,1.22,1.41,1.97,2.54,1.79,1.04,0.7,0.37,0.31:2
1.09,0.89,0.58,0.27,0.26,0.25,0.25,0.27,0.31,0.35,0.33,0.3,0.29,0.3,0.28,0.27,0.27,0.25,0.23,0.25,0.25,0.35,0.35,0.31,0.3,0.29,0.3,0.29,0.28,0.25,0.24,0.23,0.26,0.29,0.31,0.33,0.32,0.31,0.3,0.29,0.83,1.36,1.33,1.12,0.91,1.19,1.48,1.49,1.5,1.76,2.01,1.86,1.71,1.52,1.48,1.44,1.4,1.38,1.39,1.42,1.45,1.71,1.96,1.9,1.83,1.69,1.55,1.47,1.39,1.37,1.36,1.35,1.37,1.34,1.32,2.01,2.7,1.69,0.68,0.67,1.16,1.66,2.27,2.27,1.6,1.6,1.56,1.5,1.43,1.52,2.57,3.62,2.52,1.42,1.35,1.27,1.22,1.17,1.04,0.9,0.67,0.82,0.96,2.17,3.38,3.31,3.25,3.29,2.65,2.0,1.92,1.84,2.42,3.01,3.39,3.39,1.98,1.98,2.02,2.07,2.2,2.33,3.69,5.06,5.0,4.51,4.02,3.85,3.67,3.71,3.71,1.33,1.33,1.33,1.32,1.18,1.05,0.66,0.28,0.29,0.33,0.32,0.31,0.33:2
0.32,0.28,0.32,0.35,0.33,0.29,0.26,0.27,0.3,0.29,0.26,0.26,0.29,0.32,0.31,0.31,0.31,0.31,0.27,0.26,0.28,0.3,0.29,0.26,0.26,0.31,0.35,0.27,0.26,0.28,0.3,0.27,0.27,0.28,0.3,0.3,0.31,0.34,0.38,0.38,2.52,2.52,2.4,2.29,2.18,2.08,2.04,1.99,1.82,1.56,1.33,1.33,1.32,1.29,1.3,1.3,1.32,1.32,1.32,1.32,1.32,1.32,1.33,1.34,1.33,1.32,1.31,1.34,1.35,1.38,1.42,1.41,1.4,1.34,1.32,1.33,1.35,1.36,1.35,1.34,1.39,1.35,1.31,1.31,1.05,0.8,0.51,0.23,0.29,0.31,0.31,0.3,0.32,0.34,0.31,0.26,0.26,0.31,0.29,0.26,0.24,0.24,0.28,0.32,0.7,1.07,1.4,1.73,1.68,1.62,1.94,2.25,2.39,3.1,3.82,3.69,3.57,3.26,2.95,3.36,3.76,4.57,4.57,3.29,3.29,3.24,3.28,3.33,2.62,1.91,1.81,1.7,1.63,1.55,1.5,1.2,0.9,0.62,0.34,0.26,0.26,0.3,0.31,0.27:2
0.43,0.47,0.5,0.49,0.48,0.47,0.47,0.44,0.44,0.46,0.47,0.46,0.48,0.51,0.5,0.46,0.43,0.46,0.48,0.46,0.43,0.46,0.49,0.51,0.43,0.43,0.48,0.47,0.43,0.42,0.49,1.03,1.57,1.42,1.21,0.82,0.43,0.72,1.02,2.37,3.73,3.06,2.39,2.21,2.03,1.95,1.99,2.18,2.55,2.91,2.22,1.53,1.46,1.84,2.49,2.5,1.84,1.35,1.34,1.35,1.37,1.38,1.37,1.36,1.34,1.34,1.33,1.35,1.35,1.34,1.35,1.38,1.36,1.3,0.96,0.63,0.45,0.27,0.25,0.29,0.35,0.33,0.28,0.27,0.31,0.3,0.25,0.26,0.31,0.33,0.31,0.29,0.31,0.3,0.28,0.24,0.25,0.27,0.29,0.28,0.31,0.35,0.32,0.22,0.49,0.77,1.05,1.33,1.35,1.4,1.45,1.46,1.41,1.36,2.14,2.92,3.33,3.75,3.45,3.15,3.24,3.33,3.46,3.55,2.61,1.67,1.75,1.77,1.77,1.81,1.96,2.12,2.12,2.11,2.05,1.98,1.73,1.48,1.48,1.47,1.43,1.38,1.38,1.43:2
0.25,0.26,0.28,0.29,0.29,0.29,0.29,0.26,0.23,0.27,0.32,0.32,0.34,0.34,0.31,0.27,0.28,0.3,0.28,0.27,0.28,0.3,0.3,0.25,0.25,0.28,0.3,0.3,0.27,0.27,0.26,0.26,0.26,0.26,0.33,0.33,0.29,0.25,0.25,0.34,0.34,1.59,2.85,2.92,3.0,2.8,2.61,2.43,2.25,2.08,2.05,2.01,2.06,2.11,2.01,1.92,1.65,1.39,1.42,1.44,1.42,1.41,1.4,1.39,1.41,1.42,1.52,1.61,1.6,1.6,1.58,1.57,1.44,1.31,1.38,1.39,1.4,2.28,3.16,3.12,3.3,3.48,4.5,5.52,3.76,3.14,2.52,2.52,2.13,2.13,2.06,2.26,2.46,2.94,3.42,3.31,3.2,2.91,2.63,2.35,2.07,2.22,2.37,2.39,2.42,2.44,2.54,2.64,2.67,2.7,2.78,2.87,2.74,2.62,2.34,2.06,1.98,1.78,1.58,2.01,2.45,3.97,3.61,3.25,2.45,1.64,1.76,1.88,1.49,1.1,1.08,0.92,0.77,0.66,0.56,0.6,0.63,0.59,0.54,0.54,0.65,0.65,0.81,0.97:2
0.57,0.42,0.28,0.29,0.26,0.22,0.21,0.21,0.19,0.18,0.19,0.2,0.18,0.18,0.2,0.24,0.25,0.26,0.27,0.26,0.21,0.19,0.2,0.21,0.2,0.2,0.22,0.2,0.18,0.19,0.26,0.26,0.24,0.21,0.22,0.23,0.16,0.13,0.16,0.2,0.15,0.13,0.69,1.26,0.99,0.67,0.36,0.27,1.0,1.72,1.04,0.36,0.45,0.55,0.55,0.43,0.32,0.33,0.35,0.55,1.42,2.3,1.4,0.5,0.4,0.33,0.29,1.28,2.27,2.22,2.17,2.87,3.57,3.57,1.52,1.52,1.52,1.43,1.43,1.43,1.43,1.44,1.48,1.48,1.39,1.39,3.97,3.97,3.98,3.99,2.63,1.26,1.39,1.52,1.52,1.42,1.42,1.59,1.24,0.9,0.8,0.7,0.7,0.71,0.66,0.59,0.52,0.53,0.52,0.75,0.98,1.58,3.17,4.76,3.44,3.3,3.16,2.77,2.19,1.61,1.59,1.58,1.6,2.19,2.77,2.96,3.15,2.85,2.54,2.46,2.41,1.99,1.57,1.32,1.06,1.21,1.36,1.48,1.54,1.53,1.46,1.47,1.49,1.47:2
3.57,5.24,5.71,6.18,5.24,4.31,4.31,4.08,3.85,3.71,3.56,3.33,3.09,2.73,2.37,2.12,1.88,1.93,1.99,1.96,1.92,1.88,1.94,2.01,1.93,1.85,1.85,1.92,1.92,1.88,1.83,1.92,1.93,1.94,2.07,2.19,2.67,3.15,3.05,2.96,2.58,2.19,1.85,1.79,1.73,1.78,1.84,1.91,1.98,2.08,2.19,2.18,2.17,2.21,2.26,2.24,2.44,2.64,3.24,3.84,3.95,4.06,2.84,1.63,1.48,1.34,1.06,0.79,1.09,1.39,1.39,1.45,1.39,1.32,1.32,1.98,2.64,2.65,2.67,2.2,1.74,1.59,1.51,1.44,1.47,1.5,1.5,1.42,1.42,1.42,1.42,1.45,2.14,2.83,2.46,2.08,2.28,3.36,4.43,4.25,4.06,3.61,3.17,2.79,2.31,1.83,2.0,2.18,2.19,2.21,2.15,2.27,2.39,3.16,3.94,3.75,3.55,2.95,2.35,2.2,2.06,2.45,2.85,3.11,3.3,3.5,3.43,2.86,2.28,2.28,1.64,1.64,1.64,1.62,1.62,1.6,1.59,1.59,3.09,3.09,2.88,2.88,0.41,0.41:2
0.7,0.66,0.63,0.49,0.36,0.37,0.33,0.29,0.31,0.33,0.36,0.38,0.38,0.34,0.25,0.97,0.97,1.43,1.03,0.64,0.5,0.36,0.35,0.33,0.32,0.3,0.29,0.27,0.24,0.28,0.33,0.33,0.24,0.32,0.36,0.35,0.31,0.32,0.31,0.31,0.67,1.03,0.84,0.65,1.16,1.66,1.96,2.35,2.73,2.62,2.5,2.35,2.2,1.78,1.36,1.32,1.29,1.4,1.51,1.44,1.36,1.42,1.4,1.39,1.3,1.43,1.56,1.59,1.61,2.66,3.72,4.73,5.75,4.91,4.06,3.85,3.18,2.5,2.15,1.8,1.75,1.7,1.81,1.92,1.88,1.84,1.78,1.72,1.82,1.93,3.08,4.23,3.92,3.61,3.49,3.38,3.06,2.74,2.2,1.65,1.5,1.36,1.37,1.37,1.38,1.75,2.11,2.28,2.45,2.65,2.85,3.13,3.42,3.44,3.46,3.44,3.43,2.45,1.48,1.48,1.4,1.33,0.92,0.51,0.96,1.54,2.12,2.37,2.62,2.62,3.23,3.23,3.11,2.99,2.2,1.4,0.88,0.37,0.34,0.35,0.35,0.29,0.3,0.3:2
0.28,0.34,0.39,0.4,0.36,0.33,0.28,0.22,0.24,0.26,0.26,0.25,0.3,0.86,1.41,1.2,0.98,0.64,0.3,0.3,0.31,0.33,0.33,0.31,0.28,0.25,0.25,0.27,0.29,0.27,0.26,0.29,0.33,0.28,0.22,0.3,0.26,0.23,0.25,0.28,0.28,2.36,2.36,2.16,1.97,1.93,2.0,2.07,1.74,1.56,1.37,1.41,1.4,1.39,1.4,1.41,1.42,1.43,1.46,1.48,1.44,1.38,1.35,1.33,1.27,1.2,0.72,0.25,0.34,0.35,0.35,0.39,0.43,0.46,0.49,0.47,0.45,0.53,1.65,2.78,1.63,0.49,0.56,0.53,0.49,1.19,1.89,1.17,0.46,0.43,0.4,0.4,0.4,0.34,0.33,0.33,0.32,0.34,0.37,0.39,0.39,3.3,3.3,3.13,2.95,2.95,1.64,1.64,1.57,1.75,1.93,2.71,3.49,4.68,5.87,5.47,5.07,4.62,4.62,1.8,1.8,1.9,2.15,2.41,3.47,4.54,3.46,2.38,2.81,3.24,2.53,1.82,1.71,1.58,1.31,1.03,1.03,1.46,1.46,1.44,1.42,0.87,0.32,0.23:2
0.22,0.3,0.28,0.26,0.22,0.24,0.31,0.29,0.24,0.18,0.14,0.19,0.24,0.17,0.15,0.19,0.23,0.21,0.18,0.16,0.19,0.21,0.23,0.26,0.28,0.27,0.28,0.28,0.27,0.24,0.25,0.27,0.29,0.27,0.45,0.62,1.47,2.36,2.36,1.24,1.24,1.29,1.28,1.23,1.2,1.24,1.28,1.28,1.25,1.24,1.22,1.16,0.68,0.2,0.21,0.23,0.26,0.29,0.19,0.14,0.15,0.18,0.21,0.18,0.19,0.24,0.26,0.23,0.2,0.19,0.23,0.26,0.31,0.37,0.33,0.29,0.32,0.3,0.29,0.28,0.3,0.3,0.29,0.26,0.24,0.27,0.31,0.33,0.32,0.32,0.35,0.37,0.44,0.47,0.47,0.47,0.48,0.89,1.61,1.97,1.89,2.17,2.78,2.7,2.05,1.49,1.5,1.5,1.48,1.44,1.44,1.46,1.49,1.5,2.25,3.0,3.31,3.63,3.39,3.15,3.11,3.07,2.35,1.63,1.91,2.02,2.12,1.88,1.64,1.57,1.57,1.15,1.15,1.21,1.25,1.22,1.18,1.23,1.24,1.22,1.35,1.49,2.11,2.74:2
0.34,0.3,0.25,0.27,0.34,0.35,0.28,0.26,0.27,0.28,0.26,0.27,0.27,0.27,0.29,0.34,0.34,0.27,0.24,0.27,0.25,0.23,0.23,0.27,0.31,0.32,0.31,0.3,0.29,0.27,0.26,0.27,0.27,0.25,0.25,0.64,1.09,1.39,1.37,0.86,0.35,0.22,1.05,1.89,1.74,1.59,1.57,2.68,3.79,3.41,3.03,2.93,2.82,2.72,2.67,2.96,3.25,2.97,2.42,1.88,2.72,3.56,2.48,1.41,1.37,1.32,1.31,1.33,1.34,1.32,1.36,1.39,1.4,1.37,1.37,1.36,1.33,1.3,1.42,1.54,1.28,1.28,1.19,1.19,1.28,1.37,1.39,1.42,1.42,1.39,1.4,1.39,1.39,1.4,1.46,1.43,1.38,1.38,1.42,1.41,1.31,0.96,0.61,0.89,1.14,1.39,1.33,1.27,0.95,1.06,1.17,1.18,1.96,2.74,2.74,3.71,3.71,3.64,3.57,3.34,3.1,5.06,7.03,5.51,4.0,4.07,4.07,2.29,2.29,2.01,1.77,1.63,1.56,1.55,1.59,1.63,1.64,1.68,1.69,1.65,1.6,1.6,1.61,1.6:2
0.42,0.48,0.45,0.42,0.51,0.6,0.88,1.16,1.32,1.49,1.35,1.21,0.81,0.4,0.45,0.51,0.51,0.46,0.46,0.46,0.45,0.44,0.44,0.44,0.46,0.46,0.48,0.45,0.42,0.42,0.42,0.45,0.45,0.45,0.47,0.47,0.5,0.52,1.1,1.68,2.14,2.6,2.48,2.21,1.93,2.12,2.3,2.45,2.6,2.24,2.19,2.14,2.23,2.14,2.06,1.99,1.91,1.98,2.05,2.03,2.01,1.82,1.64,1.64,1.57,1.57,1.56,1.56,1.56,1.61,1.61,1.56,1.5,1.45,1.39,1.39,4.85,4.85,4.19,3.52,5.22,6.93,6.32,5.01,3.7,2.79,2.79,3.68,3.68,3.34,3.2,3.06,3.09,2.68,2.27,1.87,1.47,1.41,1.42,1.44,1.5,1.26,1.01,0.68,0.35,0.52,0.7,0.85,1.0,1.7,2.4,3.05,3.71,2.89,2.08,1.8,1.53,1.84,2.19,2.54,2.65,2.76,2.31,1.85,1.68,1.49,1.3,1.09,0.87,0.91,0.92,0.93,0.93,0.77,0.77,0.69,0.61,0.62,0.62,0.38,0.32,0.26,0.26,0.26:2
0.44,0.41,0.39,0.37,0.41,0.36,0.32,0.32,0.38,0.38,0.34,0.29,0.3,0.3,0.27,0.25,0.2,0.28,0.36,0.3,0.25,0.27,0.3,0.28,0.27,0.21,0.61,1.01,1.15,1.28,1.28,0.31,0.31,0.28,0.32,0.36,0.36,0.31,0.26,0.26,0.26,0.29,0.29,0.29,0.63,0.97,1.12,1.12,1.66,1.66,1.41,1.4,1.38,1.37,1.35,1.35,1.31,1.28,1.28,1.41,1.41,1.42,1.44,1.46,1.49,1.71,1.94,2.39,2.83,2.64,2.47,2.29,1.84,1.39,0.93,0.47,0.27,0.38,0.48,0.64,0.81,0.78,0.76,1.47,2.17,2.17,0.42,0.42,0.98,1.54,1.48,1.74,2.01,1.77,1.53,1.02,0.5,0.51,0.52,0.51,0.5,0.46,0.43,0.45,0.48,1.46,2.43,3.27,4.1,3.03,1.97,1.74,1.87,1.99,1.95,2.16,2.36,2.66,2.95,2.41,1.87,1.77,1.68,2.05,2.43,2.59,3.27,3.95,2.62,1.3,1.21,1.24,1.27,1.32,1.85,2.39,1.89,1.39,1.39,1.52,1.65,1.37,1.04,0.72:2
2.19,1.91,1.63,0.99,0.34,0.29,0.29,0.3,0.3,0.27,0.25,0.27,0.28,0.28,0.27,0.27,0.3,0.3,0.26,0.22,0.23,0.24,0.26,0.28,0.28,0.38,0.38,0.31,0.23,0.23,0.23,0.27,0.31,0.31,0.28,0.28,0.3,0.31,0.57,0.83,1.6,2.13,2.65,2.67,2.69,2.73,2.76,2.78,2.86,2.95,2.33,1.7,2.11,1.92,1.73,1.51,1.28,1.37,1.4,1.43,1.43,1.36,1.36,1.35,1.33,1.29,1.29,1.4,1.4,1.48,1.57,1.89,1.88,1.88,1.86,1.85,1.72,1.58,1.47,1.36,1.49,1.62,2.3,2.99,3.01,2.23,1.44,1.47,1.49,1.6,1.96,2.33,2.33,0.33,0.33,0.26,0.28,0.3,0.29,0.28,0.28,1.63,1.63,1.86,2.09,2.06,2.02,2.02,2.73,2.73,2.47,2.21,2.14,2.01,1.87,2.24,2.61,3.02,3.42,3.3,3.18,2.93,2.69,2.64,2.08,1.53,1.48,1.48,4.78,4.78,4.35,4.03,3.7,2.99,2.29,1.54,0.94,0.35,0.25,0.58,0.9,0.8,0.71,0.69:2
0.32,0.32,0.32,0.28,0.25,0.32,0.39,0.31,0.22,0.29,0.35,0.81,1.26,1.4,1.19,0.98,0.6,0.23,0.29,0.34,0.29,0.23,0.29,0.27,0.24,0.29,0.33,0.33,0.32,0.32,0.32,0.32,0.28,0.24,0.27,0.3,0.3,0.29,0.32,0.34,0.45,1.35,2.25,2.14,2.03,2.02,2.02,1.8,1.58,1.59,1.47,1.34,1.35,1.34,1.33,1.35,1.36,1.36,1.3,1.3,1.37,1.44,1.4,1.37,1.42,1.48,1.26,1.03,0.8,0.57,0.47,0.37,0.37,0.37,0.87,1.36,0.89,0.42,0.37,0.36,0.34,0.34,0.44,0.44,0.44,0.36,0.36,0.36,0.36,0.35,0.91,1.47,1.4,1.34,1.82,2.3,2.09,1.87,1.82,1.77,1.74,1.7,1.72,1.74,1.73,1.71,2.65,3.59,3.76,3.92,3.62,3.31,2.94,2.58,2.41,2.24,1.9,3.33,4.77,4.47,4.91,5.35,4.03,4.03,2.32,2.32,2.78,3.24,2.95,2.66,2.14,1.62,1.95,2.27,3.36,4.46,3.46,2.46,2.39,2.29,2.18,1.98,3.23,4.49:2
0.33,0.3,0.3,0.3,0.34,0.35,0.36,0.33,0.29,0.29,0.28,0.28,0.28,0.28,0.28,0.83,1.38,1.21,1.04,0.68,0.32,0.3,0.28,0.27,0.27,0.36,0.36,0.33,0.31,0.27,0.27,0.28,0.28,0.28,0.28,0.28,0.38,0.38,1.16,1.96,2.28,2.13,1.86,1.58,1.77,1.96,2.67,3.37,2.41,1.45,1.96,2.47,2.78,2.05,1.32,1.29,1.28,1.27,1.32,1.36,1.29,1.21,0.95,0.68,0.49,0.29,0.29,0.29,0.31,0.34,0.37,0.33,0.29,0.29,0.28,0.28,0.28,0.27,0.31,0.34,0.32,0.29,0.3,0.32,0.3,0.28,0.21,0.27,0.33,0.34,0.36,0.33,0.3,0.3,0.33,0.36,0.29,0.22,0.27,0.32,0.32,0.33,0.33,0.33,0.37,0.4,0.52,0.63,0.93,1.23,1.35,1.45,1.56,2.75,3.95,3.46,3.11,2.76,2.17,1.57,1.81,2.05,3.33,4.61,4.75,4.88,4.61,5.32,6.04,4.41,4.07,3.74,3.6,3.46,3.46,0.46,0.46,0.4,0.35,0.33,0.31,0.31,0.31,0.31:2
1.51,1.35,1.0,0.64,0.44,0.24,0.29,0.34,0.29,0.25,0.29,0.33,0.34,0.34,0.34,0.35,0.31,0.26,0.29,0.31,0.29,0.27,0.29,0.3,0.3,0.3,0.33,0.36,0.36,0.36,0.31,0.26,0.26,0.34,0.25,0.25,0.36,0.37,0.26,0.37,0.37,0.36,0.35,0.34,0.33,0.31,0.29,0.3,0.32,0.31,0.31,0.31,0.3,0.31,0.32,0.34,0.37,0.42,0.4,0.38,0.39,0.73,1.07,1.21,1.36,1.55,2.2,2.85,1.7,0.55,0.55,0.55,0.48,0.42,0.42,0.41,0.39,1.36,2.34,3.71,5.08,3.99,2.9,3.23,3.55,2.51,2.51,1.59,1.59,2.68,3.76,4.05,4.35,3.84,3.34,2.65,1.96,2.18,2.4,2.33,2.26,2.27,2.27,2.27,2.27,2.34,2.74,3.15,4.42,5.7,5.2,4.7,4.5,4.23,3.96,3.67,3.05,2.43,2.47,2.52,2.52,4.05,4.05,4.03,4.01,3.66,3.3,4.48,5.66,5.08,4.11,3.15,2.79,2.44,2.08,1.72,1.74,1.7,1.66,1.45,1.42,1.39,1.42,1.46:2
0.23,0.24,0.36,0.48,0.9,1.31,1.02,0.72,0.39,0.32,0.24,0.26,0.26,0.26,0.27,0.27,0.28,0.25,0.22,0.24,0.28,0.29,0.3,0.3,0.3,0.31,0.26,0.22,0.22,0.26,0.26,0.26,0.22,0.22,0.27,0.33,0.23,0.48,0.74,0.74,1.33,1.33,1.81,2.29,2.37,2.36,2.34,2.59,2.83,3.24,3.66,2.57,1.48,2.14,2.79,2.08,1.37,1.4,1.44,1.39,1.37,1.41,1.39,1.37,1.37,1.38,1.41,1.43,1.82,2.21,2.48,2.75,2.93,3.12,4.45,5.78,4.97,4.17,4.04,3.91,3.39,3.42,3.45,3.44,3.44,3.64,3.84,3.53,3.22,3.21,3.19,3.16,2.76,2.35,1.55,0.76,0.66,0.56,0.47,0.47,0.48,0.44,0.4,0.73,1.06,1.46,1.86,2.27,2.68,2.96,3.24,3.09,3.04,2.99,2.88,3.11,3.35,2.57,1.79,1.8,1.82,1.85,1.88,2.67,3.45,4.03,4.61,4.72,4.72,3.19,3.19,2.73,2.26,1.95,1.65,1.53,1.42,1.34,1.43,1.51,1.15,1.33,1.51,2.11:2
0.41,0.6,0.8,1.17,1.26,1.35,1.34,1.33,0.94,0.56,0.56,0.29,0.29,0.29,0.3,0.31,0.3,0.3,0.25,0.25,0.25,0.25,0.35,0.3,0.3,0.29,0.27,0.28,0.27,0.26,0.26,0.27,0.33,0.3,0.29,0.3,0.3,0.28,0.26,0.25,0.23,0.28,0.33,0.84,1.34,1.66,1.97,2.34,2.71,2.77,2.84,2.76,2.75,2.74,2.19,1.64,1.51,1.37,1.46,1.56,1.43,1.3,2.71,4.12,3.74,3.36,3.45,3.45,3.07,3.07,3.15,2.64,2.12,2.04,1.7,1.36,1.05,0.73,0.65,0.56,1.14,1.73,1.85,1.98,2.79,3.61,3.5,3.39,3.39,1.41,1.41,1.41,1.46,1.46,1.45,1.51,1.58,1.81,2.04,2.48,2.92,2.64,3.07,3.5,3.88,4.74,5.6,6.17,4.87,3.57,3.42,3.53,3.64,3.64,3.26,2.88,2.88,2.88,2.88,4.2,4.2,3.8,3.4,3.24,3.08,3.06,2.89,2.72,2.72,1.83,1.83,2.08,2.08,1.66,1.66,1.6,1.39,1.18,1.32,1.46,1.69,1.91,2.06,2.21:2
